% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-lines.R
\name{md_paragraph}
\alias{md_paragraph}
\title{Markdown paragraphs breaks}
\usage{
md_paragraph(...)
}
\arguments{
\item{...}{Any number of character vectors.}
}
\value{
A \code{glue} vector with elements of \code{...} separated by two newlines.
}
\description{
Take a character vector and return a glue vector of paragraphs separated by
double newlines. This leaf block is rendered as distinct \code{<p>} HTML tags.
}
\details{
A sequence of non-blank lines that cannot be interpreted as other kinds of
blocks forms a paragraph. The contents of the paragraph are the result of
parsing the paragraph’s raw content as inlines. The paragraph’s raw content
is formed by concatenating the lines and removing initial and final
whitespace... Paragraphs can contain multiple lines, but no blank lines.
}
\examples{
md_paragraph(stringr::sentences[1:3])
}
\seealso{
Other leaf block functions: \code{\link{md_blank}},
  \code{\link{md_chunk}}, \code{\link{md_fence}},
  \code{\link{md_heading}}, \code{\link{md_indent}},
  \code{\link{md_reference}}, \code{\link{md_rule}},
  \code{\link{md_setext}}, \code{\link{md_table}}
}
\concept{leaf block functions}
