% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{aucuba}
\alias{aucuba}
\title{Lesions of Aucuba mosaic virus}
\format{
A data frame with 7 rows and 2 variables:
\describe{
  \item{time}{ a numeric vector giving the minutes of exposure.}
  \item{lesions}{ a numeric vector giving the counts of lesions, in hundreds.}
}
}
\usage{
data(aucuba)
}
\description{
The investigators counted the number of lesions
of \emph{Aucuba mosaic} virus developing after exposure to X
rays for various times. See Snedecor and Cochran (1980, page 404).
}
\examples{
barplot(lesions ~ time, col="red", data=aucuba)

}
\references{
Snedecor G.W. and Cochran W.G. (1989) \emph{Statistical Methods, Eight Edition}, Iowa State University Press, Ames.
}
\keyword{datasets}
