% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{SGPC}
\alias{SGPC}
\title{SGPC for Generalized Estimating Equations}
\usage{
SGPC(..., verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class glmgee which are obtained from the fit of generalized estimating equations.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
A \code{data.frame} with the values of the gaussian pseudo-likelihood, the number of parameters in the linear predictor plus the number of parameters in the correlation matrix, and the value of SGPC for each glmgee object in the input.
}
\description{
Computes the Schwarz-type penalized Gaussian pseudo-likelihood criterion (SGPC) for one or more objects of the class glmgee.
}
\examples{
## Example 1
mod <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="Exchangeable")
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
SGPC(fit1, fit2, fit3, fit4)

## Example 2
mod <- dep ~ visit + group
fit1 <- glmgee(mod, id=subj, family=gaussian, corstr="Exchangeable", data=depression)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Non-Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
SGPC(fit1, fit2, fit3, fit4)

## Example 3
mod <- depressd ~ visit + group
fit1 <- glmgee(mod, id=subj, family=binomial, corstr="Exchangeable", data=depression)
fit2 <- update(fit1, corstr="AR-1")
fit3 <- update(fit1, corstr="Stationary-M-dependent(2)")
fit4 <- update(fit1, corstr="Independence")
SGPC(fit1, fit2, fit3, fit4)
}
\references{
Carey V.J. and Wang Y.-G. (2011) Working covariance model selection for generalized estimating equations. \emph{Statistics in Medicine} 30, 3117–3124.

Zhu X. and Zhu Z. (2013) Comparison of criteria to select working correlation matrix in generalized estimating
equations. \emph{Chinese Journal of Applied Probability and Statistics} 29, 515-530.

Fu L., Hao Y. and Wang Y.-G. (2018) Working correlation structure selection in generalized
estimating equations. \emph{Computational Statistics} 33, 983-996.
}
\seealso{
\link{QIC}, \link{CIC}, \link{RJC}, \link{GHYC}, \link{AGPC}
}
