% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6ModelExtMCML.R
\name{ModelMCML}
\alias{ModelMCML}
\title{Extension to the Model class to use Markov Chain Monte Carlo Maximum Likelihood}
\value{
No return value, called for side effects.
}
\description{
Extension to the Model class to use Markov Chain Monte Carlo Maximum Likelihood

Extension to the Model class to use Markov Chain Monte Carlo Maximum Likelihood
}
\details{
An R6 class representing a GLMM and study design

For the generalised linear mixed model

\deqn{Y \sim F(\mu,\sigma)}
\deqn{\mu = h^-1(X\beta + Z\gamma)}
\deqn{\gamma \sim MVN(0,D)}

where h is the link function. A Model in comprised of a \link[glmmrBase]{MeanFunction} object, which defines the family F,
link function h, and fixed effects design matrix X, and a \link[glmmrBase]{Covariance} object, which defines Z and D.

This class extends the \link[glmmrBase]{Model} class of the \code{glmmrBase} package by adding the member function \code{MCML()}, which
provides Markov Chain Monte Carlo Maximum Likelihood model fitting. See \href{https://github.com/samuel-watson/glmmrBase/blob/master/README.md}{glmmrBase} for a
detailed guide on model specification.

\strong{MCMCML}
Fits generalised linear mixed models using one of three algorithms: Markov Chain Newton
Raphson (MCNR), Markov Chain Expectation Maximisation (MCEM), or Maximum simulated
likelihood (MSL). All the algorithms are described by McCullagh (1997). For each iteration
of the algorithm the unobserved random effect terms (\eqn{\gamma}) are simulated
using Markov Chain Monte Carlo (MCMC) methods (we use Hamiltonian Monte Carlo through Stan),
and then these values are conditioned on in the subsequent steps to estimate the covariance
parameters and the mean function parameters (\eqn{\beta}). For all the algorithms,
the covariance parameter estimates are updated using an expectation maximisation step.
For the mean function parameters you can either use a Newton Raphson step (MCNR) or
an expectation maximisation step (MCEM). A simulated likelihood step can be added at the
end of either MCNR or MCEM, which uses an importance sampling technique to refine the
parameter estimates.

The accuracy of the algorithm depends on the user specified tolerance. For higher levels of
tolerance, larger numbers of MCMC samples are likely need to sufficiently reduce Monte Carlo error.

The function also offers different methods of obtaining standard errors. One can generate
estimates from the estimated Hessian matrix (\code{se.method = 'lik'}).
Or use approximate generalised least squares estimates based on the maximum likelihood
estimates of the covariance parameters (\code{se.method = 'approx'}).

Options for the MCMC sampler are set by changing the values in \code{self$mcmc_options}

There are several options that can be specified to the function using the \code{options} argument.
The options should be provided as a list, e.g. \code{options = list(method="mcnr")}. The possible options are:
\itemize{
\item \code{no_warnings} TRUE (do not report any warnings) or FALSE (report warnings), default to FALSE
\item \code{fd_tol} The tolerance of the first difference method to estimate the Hessian and Gradient, default
is 1e-4.
\item \code{trace} Level of detail to report in output: 0 = no detail (default), 1 & 2 = detailed return from BOBYQA
}

\strong{Laplace approximation}
Fits generalised linear mixed models using Laplace approximation.
}
\examples{

## ------------------------------------------------
## Method `ModelMCML$MCML`
## ------------------------------------------------

\dontrun{
df <- nelder(~(cl(10)*t(5)) > ind(10))
df$int <- 0
df[df$cl > 5, 'int'] <- 1
# specify parameter values in the call for the data simulation below
des <- ModelMCML$new(
  covariance = list( formula = ~ (1|gr(cl)*ar1(t)),
                     parameters = c(0.25,0.7)), 
  mean = list(formula = ~ factor(t) + int - 1,
                        parameters = c(rep(0,5),0.2)),
  data = df,
  family = gaussian()
)
ysim <- des$sim_data() # simulate some data from the model
fit1 <- des$MCML(y = ysim,method="mcnr",usestan=FALSE)
#fits the models using Stan 
fit2 <- des$MCML(y = ysim,method="mcnr")
 #adds a simulated likelihood step after the MCEM algorithm
fit3 <- des$MCML(y = ysim, sim.lik.step = TRUE)  

 # we could use LA to find better starting values
fit4 <- des$LA(y=ysim)
# to set better starting values we can use the update_parameters function 
des$update_parameters(mean = fit4$coefficients$est[1:6], 
                     cov = fit4$coefficients$est[7:8])
fit5 <- des$MCML(y = ysim,method="mcnr") # it should converge much more quickly                    
}

## ------------------------------------------------
## Method `ModelMCML$LA`
## ------------------------------------------------

\dontrun{
df <- nelder(~(cl(10)*t(5)) > ind(10))
df$int <- 0
df[df$cl > 5, 'int'] <- 1
# specify parameter values in the call for the data simulation below
des <- ModelMCML$new(
  covariance = list( formula = ~ (1|gr(cl)*ar1(t)),
                     parameters = c(0.25,0.7)), 
  mean = list(formula = ~ factor(t) + int - 1,
                        parameters = c(rep(0,5),-0.2)),
  data = df,
  family = stats::binomial()
)
ysim <- des$sim_data() # simulate some data from the model
fit1 <- des$LA(y = ysim)
}
}
\seealso{
\link[glmmrBase]{Model}, \link[glmmrBase]{Covariance}, \link[glmmrBase]{MeanFunction}

\link[glmmrBase]{Model}, \link[glmmrBase]{Covariance}, \link[glmmrBase]{MeanFunction}
}
\section{Super class}{
\code{\link[glmmrBase:Model]{glmmrBase::Model}} -> \code{ModelMCML}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{mcmc_options}}{There are five options for MCMC sampling that are specified in this list:
\itemize{
\item \code{warmup} The number of warmup iterations. Note that if using the internal HMC
sampler, this only applies to the first iteration of the MCML algorithm, as the
values from the previous iteration are carried over.
\item \code{samps} The number of MCMC samples drawn in the MCML algorithm. For
smaller tolerance values larger numbers of samples are required. For the internal
HMC sampler, larger numbers of samples are generally required than if using Stan since
the samples generally exhibit higher autocorrealtion, especially for more complex
covariance structures.
\item \code{lambda} (Only relevant for the internal HMC sampler) Value of the trajectory length of the leapfrog integrator in Hamiltonian Monte Carlo
(equal to number of steps times the step length). Larger values result in lower correlation in samples, but
require larger numbers of steps and so is slower. Smaller numbers are likely required for non-linear GLMMs.
\item \code{refresh} How frequently to print to console MCMC progress if displaying verbose output.
\item \code{maxsteps} (Only relevant for the internal HMC sampler) Integer. The maximum number of steps of the leapfrom integrator
}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ModelMCML-MCML}{\code{ModelMCML$MCML()}}
\item \href{#method-ModelMCML-LA}{\code{ModelMCML$LA()}}
\item \href{#method-ModelMCML-clone}{\code{ModelMCML$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="check"><a href='../../glmmrBase/html/Model.html#method-Model-check'><code>glmmrBase::Model$check()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="fitted"><a href='../../glmmrBase/html/Model.html#method-Model-fitted'><code>glmmrBase::Model$fitted()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="information_matrix"><a href='../../glmmrBase/html/Model.html#method-Model-information_matrix'><code>glmmrBase::Model$information_matrix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="initialize"><a href='../../glmmrBase/html/Model.html#method-Model-initialize'><code>glmmrBase::Model$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="n"><a href='../../glmmrBase/html/Model.html#method-Model-n'><code>glmmrBase::Model$n()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="n_cluster"><a href='../../glmmrBase/html/Model.html#method-Model-n_cluster'><code>glmmrBase::Model$n_cluster()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="power"><a href='../../glmmrBase/html/Model.html#method-Model-power'><code>glmmrBase::Model$power()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="print"><a href='../../glmmrBase/html/Model.html#method-Model-print'><code>glmmrBase::Model$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="sim_data"><a href='../../glmmrBase/html/Model.html#method-Model-sim_data'><code>glmmrBase::Model$sim_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="subset_cols"><a href='../../glmmrBase/html/Model.html#method-Model-subset_cols'><code>glmmrBase::Model$subset_cols()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="subset_rows"><a href='../../glmmrBase/html/Model.html#method-Model-subset_rows'><code>glmmrBase::Model$subset_rows()</code></a></span></li>
<li><span class="pkg-link" data-pkg="glmmrBase" data-topic="Model" data-id="update_parameters"><a href='../../glmmrBase/html/Model.html#method-Model-update_parameters'><code>glmmrBase::Model$update_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelMCML-MCML"></a>}}
\if{latex}{\out{\hypertarget{method-ModelMCML-MCML}{}}}
\subsection{Method \code{MCML()}}{
Markov Chain Monte Carlo Maximum Likelihood  model fitting
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelMCML$MCML(
  y,
  start,
  se.method = "approx",
  method = "mcnr",
  sim.lik.step = FALSE,
  verbose = TRUE,
  tol = 0.01,
  max.iter = 30,
  sparse = FALSE,
  usestan = TRUE,
  options = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{A numeric vector of outcome data}

\item{\code{start}}{Optional. A numeric vector indicating starting values for the MCML algorithm iterations.
If this is not specified then the parameter values stored in the linked mean function object will be used.}

\item{\code{se.method}}{One of either \code{'lik'}, \code{'approx'}, \code{'perm'}, or \code{'none'}, see Details.}

\item{\code{method}}{The MCML algorithm to use, either \code{mcem} or \code{mcnr}, see Details. Default is \code{mcem}.}

\item{\code{sim.lik.step}}{Logical. Either TRUE (conduct a simulated likelihood step at the end of the algorithm), or FALSE (does
not do this step), defaults to FALSE.}

\item{\code{verbose}}{Logical indicating whether to provide detailed output, defaults to TRUE.}

\item{\code{tol}}{Numeric value, tolerance of the MCML algorithm, the maximum difference in parameter estimates
between iterations at which to stop the algorithm.}

\item{\code{max.iter}}{Integer. The maximum number of iterations of the MCML algorithm.}

\item{\code{sparse}}{Logical indicating whether to use sparse matrix methods}

\item{\code{usestan}}{Logical whether to use Stan (through the package \code{cmdstanr}) for the MCMC sampling. If FALSE then
the internal Hamiltonian Monte Carlo sampler will be used instead. We recommend Stan over the internal sampler as
it generally produces a larger number of effective samplers per unit time, especially for more complex
covariance functions.}

\item{\code{options}}{An optional list providing options to the algorithm, see Details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{mcml} object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
df <- nelder(~(cl(10)*t(5)) > ind(10))
df$int <- 0
df[df$cl > 5, 'int'] <- 1
# specify parameter values in the call for the data simulation below
des <- ModelMCML$new(
  covariance = list( formula = ~ (1|gr(cl)*ar1(t)),
                     parameters = c(0.25,0.7)), 
  mean = list(formula = ~ factor(t) + int - 1,
                        parameters = c(rep(0,5),0.2)),
  data = df,
  family = gaussian()
)
ysim <- des$sim_data() # simulate some data from the model
fit1 <- des$MCML(y = ysim,method="mcnr",usestan=FALSE)
#fits the models using Stan 
fit2 <- des$MCML(y = ysim,method="mcnr")
 #adds a simulated likelihood step after the MCEM algorithm
fit3 <- des$MCML(y = ysim, sim.lik.step = TRUE)  

 # we could use LA to find better starting values
fit4 <- des$LA(y=ysim)
# to set better starting values we can use the update_parameters function 
des$update_parameters(mean = fit4$coefficients$est[1:6], 
                     cov = fit4$coefficients$est[7:8])
fit5 <- des$MCML(y = ysim,method="mcnr") # it should converge much more quickly                    
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelMCML-LA"></a>}}
\if{latex}{\out{\hypertarget{method-ModelMCML-LA}{}}}
\subsection{Method \code{LA()}}{
Maximum Likelihood model fitting with Laplace Approximation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelMCML$LA(y, start, method = "nr", use.hess = FALSE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{y}}{A numeric vector of outcome data}

\item{\code{start}}{Optional. A numeric vector indicating starting values for the model parameters.}

\item{\code{method}}{String. Either "nloptim" for non-linear optimisation, or "nr" for Newton-Raphson algorithm}

\item{\code{use.hess}}{Logical indicating whether to estimate the standard errors using the Hessian (TRUE) or (approximate) information matrix (FALSE)}

\item{\code{verbose}}{logical indicating whether to provide detailed algorithm feedback.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{mcml} object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
df <- nelder(~(cl(10)*t(5)) > ind(10))
df$int <- 0
df[df$cl > 5, 'int'] <- 1
# specify parameter values in the call for the data simulation below
des <- ModelMCML$new(
  covariance = list( formula = ~ (1|gr(cl)*ar1(t)),
                     parameters = c(0.25,0.7)), 
  mean = list(formula = ~ factor(t) + int - 1,
                        parameters = c(rep(0,5),-0.2)),
  data = df,
  family = stats::binomial()
)
ysim <- des$sim_data() # simulate some data from the model
fit1 <- des$LA(y = ysim)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ModelMCML-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ModelMCML-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ModelMCML$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
