% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VarCorr.R
\name{VarCorr.glmmTMB}
\alias{VarCorr.glmmTMB}
\alias{VarCorr}
\title{Extract variance and correlation components}
\usage{
\method{VarCorr}{glmmTMB}(x, sigma = 1, ...)
}
\arguments{
\item{x}{a fitted \code{glmmTMB} model}

\item{sigma}{residual standard deviation (usually set automatically from internal information)}

\item{extra}{arguments (for consistency with generic method)}
}
\description{
Extract variance and correlation components
}
\details{
For an unstructured variance-covariance matrix, the internal parameters
are structured as follows: the first n parameters are the log-standard-deviations,
while the remaining n(n-1)/2 parameters are the elements of the Cholesky factor
of the correlation matrix, filled in column-wise order
(see the \href{http://kaskr.github.io/adcomp/classdensity_1_1UNSTRUCTURED__CORR__t.html}{TMB documentation}
for further details).
}
\examples{
## Comparing variance-covariance matrix with manual computation
data("sleepstudy",package="lme4")
fm4 <- glmmTMB(Reaction ~ Days + (Days|Subject), sleepstudy)
VarCorr(fm4)[[c("cond","Subject")]]
## hand calculation
pars <- getME(fm4,"theta")
## construct cholesky factor
L <- diag(2)
L[lower.tri(L)] <- pars[-(1:2)]
C <- crossprod(L)
diag(C) <- 1
sdvec <- exp(pars[1:2])
(V <- outer(sdvec,sdvec) * C)
}
\keyword{internal}
