% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.gllvm.R
\name{confint.gllvm}
\alias{confint.gllvm}
\alias{confint}
\title{Confidence intervals for model parameters}
\usage{
\method{confint}{gllvm}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{parm}{a specification of which parameters are to be given confidence intervals, a vector of names. Examples of options are "beta0", "Xcoef",theta", "phi". If missing, all parameters are considered.}

\item{level}{the confidence level. Scalar between 0 and 1.}

\item{...}{not used.}
}
\description{
Computes confidence intervals for  parameters in a fitted gllvm model.
}
\examples{
\dontrun{
## Load a dataset from the mvabund package
data(antTraits, package = "mvabund")
y <- as.matrix(antTraits$abund)
X <- as.matrix(antTraits$env[,1:2])
# Fit gllvm model
fit <- gllvm(y = y, X = X, family = poisson())
# 95 \% confidence intervals for coefficients of X variables
confint(fit, level = 0.95, parm = "Xcoef")
}
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>
}
