% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-methods.R
\name{print.summary.gkwreg}
\alias{print.summary.gkwreg}
\title{Print Method for Generalized Kumaraswamy Regression Summaries}
\usage{
\method{print}{summary.gkwreg}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{"summary.gkwreg"}, typically the result of
a call to \code{\link{summary.gkwreg}}.}

\item{digits}{Integer, controlling the number of significant digits to print.
Defaults to \code{max(3, getOption("digits") - 3)}.}

\item{signif.stars}{Logical. If \code{TRUE}, significance stars are printed
next to the p-values in the coefficient table. Defaults to the value of
\code{getOption("show.signif.stars")}.}

\item{...}{Additional arguments, currently ignored by this method.}
}
\value{
Invisibly returns the original input object \code{x}. This allows the
output of \code{print()} to be assigned, but it primarily prints the formatted
summary to the console.
}
\description{
Formats and prints the summary output of a fitted Generalized Kumaraswamy
(GKw) regression model (objects of class \code{"summary.gkwreg"}).
}
\details{
This is the print method for objects created by \code{\link{summary.gkwreg}}.
It formats the summary information for display in the console. It is typically
invoked automatically when \code{print()} is called on a \code{summary.gkwreg}
object, or simply by typing the name of the summary object in an interactive R session.

The output includes:
\itemize{
\item Model family and the original function call.
\item Summary statistics for residuals.
\item A coefficient table with estimates, standard errors, z-values, and
p-values, optionally marked with significance stars (using
\code{\link[stats]{printCoefmat}}).
\item Confidence intervals for coefficients (if available).
\item Link functions used for each parameter.
\item Mean values of the fitted distribution parameters.
\item Key model fit statistics (LogLik, AIC, BIC, RMSE, R^2, etc.).
\item Convergence status and number of iterations.
}
}
\seealso{
\code{\link{summary.gkwreg}}, \code{\link{gkwreg}},
\code{\link[stats]{printCoefmat}}
}
\author{
Lopes, J. E.
}
\keyword{hoss}
\keyword{internal}
\keyword{methods}
\keyword{print}
