% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.r
\docType{methods}
\name{tags}
\alias{tags}
\alias{tags,missing-method}
\alias{tags,git_repository-method}
\title{Tags}
\usage{
tags(repo)

\S4method{tags}{missing}()

\S4method{tags}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository \code{object}
\code{\linkS4class{git_repository}}. If the \code{repo} argument
is missing, the repository is searched for with
\code{\link{discover_repository}} in the current working
directory.}
}
\value{
list of tags in repository
}
\description{
Tags
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

## List tags
tags(repo)
}
}
\keyword{methods}
