% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.r
\docType{methods}
\name{branch_set_upstream}
\alias{branch_set_upstream}
\alias{branch_set_upstream,git_branch-method}
\title{Set remote tracking branch}
\usage{
branch_set_upstream(branch, name)

\S4method{branch_set_upstream}{git_branch}(branch, name)
}
\arguments{
\item{branch}{The branch to configure}

\item{name}{remote-tracking or local branch to set as
upstream. Pass NULL to unset.}
}
\value{
invisible NULL
}
\description{
Set the upstream configuration for a given local branch
}
\examples{
\dontrun{
## Initialize two temporary repositories
path_bare <- tempfile(pattern="git2r-")
path_repo <- tempfile(pattern="git2r-")
dir.create(path_bare)
dir.create(path_repo)
repo_bare <- init(path_bare, bare = TRUE)
repo <- clone(path_bare, path_repo)

## Config user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Push commits from repository to bare repository
## Adds an upstream tracking branch to branch 'master'
push(repo, "origin", "refs/heads/master")

## Unset remote remote tracking branch
branch_get_upstream(head(repo))
branch_set_upstream(head(repo), NULL)
branch_get_upstream(head(repo))

## Set remote tracking branch
branch_set_upstream(head(repo), "origin/master")
branch_get_upstream(head(repo))
}
}
\keyword{methods}

