% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_postalcodes.R
\name{gisco_get_postalcodes}
\alias{gisco_get_postalcodes}
\title{Get postal code points from GISCO}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/postal-codes}
}
\usage{
gisco_get_postalcodes(
  year = "2020",
  country = NULL,
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{year}{Year of reference. Currently only "2020" is available.}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Turkey","US","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
.geojson file.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
A \code{POINT} object on EPSG:4326.
}
\description{
Get postal codes points of the EU, EFTA and candidate countries.
}
\details{
The postal code point dataset shows the location of postal codes, NUTS codes
and the Degree of Urbanisation classification across the EU, EFTA and
candidate countries from a variety of sources. Its primary purpose is to
create correspondence tables for the NUTS classification (EC) 1059/2003 as
part of the Tercet Regulation (EU) 2017/2391
}
\section{Copyright}{
The dataset is released under the CC-BY-SA-4.0 licence and requires the
following attribution whenever used:

\emph{(c) European Union - GISCO, 2021, postal code point dataset, Licence
CC-BY-SA 4.0 available at
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data}}

Shapefiles provided in ETRS89 (\href{https://epsg.io/4258}{EPSG:4258}).
}

\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{

# Heavy-weight download!
\dontrun{

pc_bel <- gisco_get_postalcodes(country = "BE")

library(ggplot2)

ggplot(pc_bel) +
  geom_sf(color = "gold") +
  theme_bw() +
  labs(
    title = "Postcodes of Belgium",
    subtitle = "2020",
    caption = paste("(c) European Union - GISCO, 2021,",
      "postal code point dataset",
      "Licence CC-BY-SA 4.0",
      sep = "\n"
    )
  )
}
}
\seealso{
Other political: 
\code{\link{gisco_bulk_download}()},
\code{\link{gisco_get_coastallines}()},
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_units}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{political}
