\name{semigimme}
\alias{semigimme}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Semi-confirmatory group iterative multiple model estimation.
}
\description{
This function identifies structural equation models consisting of group- and individual-level paths. The unique feature of this function is the ability to specify relations (paths) with which to begin model estimation. 
}
\usage{
semigimme(paths, data, sep, header, out, plot = TRUE, ar = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{paths}{
Comma separated vector containing paths with which to begin estimation, written in the style of lavaan syntax. That is, Y~X indicates that Y is regressed on X, or X predicts Y. If no header is used, then variables should be referred to with VAR followed (with no separation) by the column number. If a header is used, variables should be referred to using variable names. To reference lag variables, "lag" should be added to the end of the variable name with no separation.
  }
  \item{data}{
Path to the directory where the data files are located. Each file must contain one matrix for each individual containing a T (time) by p (number of variables) matrix where the columns represent variables and the rows represent time.
}
  \item{sep}{
The spacing of the data files. "" indicates space-delimited, "/t" indicates tab-delimited, "," indicates comma delimited.
}
  \item{header}{
Logical. Indicate TRUE for data files with a header.
}
  \item{out}{
The path to the directory where the results will be stored. This directory must be generated by the user prior to running the function.
}
  \item{ar}{
Logical. If TRUE, begins search for group model with autoregressive (AR) paths open. Defaults to FALSE.
}
  \item{plot}{
Logical. If TRUE, graphs depicting relations among variables of interest will automatically be created. Defaults to TRUE.
}
}
\value{
\item{all.elements.summary}{Contains summary information for paths identified at the group- and individual-level.}
\item{all.elements}{Contains information for all paths identified at the group- and individual-level.}
\item{all.fit}{Contains model fit information for individual-level models.}
}
\author{
Stephanie Lane
}
\examples{
\dontrun{
semigimme.out <- semigimme(paths=c("VAR10~VAR6","VAR8~VAR3lag","VAR4~VAR3"),
                 data = "C:/data100",
                 sep = ",",
                 header = FALSE,
                 out = "C:/data100_semigimme_out",
                 ar = TRUE,
                 plot = TRUE)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{semigimme}

