% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ghcm_test}
\alias{ghcm_test}
\title{Conditional Independence Test using the GHCM}
\usage{
ghcm_test(resid_X_on_Z, resid_Y_on_Z, alpha = 0.05)
}
\arguments{
\item{resid_X_on_Z, resid_Y_on_Z}{Numeric vectors or matrices. Residuals
when regressing X (Y) on Z with a suitable regression method.}

\item{alpha}{Numeric in the unit interval. Significance level of the test.}
}
\value{
An object of class \code{ghcm} containing:
  \describe{
    \item{\code{test_statistic}}{Numeric, test statistic of the test.}
    \item{\code{p}}{Numeric in the unit interval, estimated p-value of
     the test.}
    \item{\code{cov}}{matrix, estimated covariance
     of the truncated limiting Gaussian.}
    \item{\code{alpha}}{Numeric in the unit interval, significance level
     of the test.}
  }
}
\description{
Testing X independent of Y given Z using the Generalised Hilbertian
 Covariance Measure. The function is applied to residuals from regressing X on Z
 and regressing Y on Z and its validity is contingent on the performance
 of the regression methods.
}
\examples{
library(refund)
set.seed(1)
data(ghcm_sim_data)
grid <- seq(0, 1, length.out = 101)

# Test independence of two scalars given a functional variable

m_1 <- pfr(Y_1 ~ lf(Z), data=ghcm_sim_data)
m_2 <- pfr(Y_2 ~ lf(Z), data=ghcm_sim_data)
ghcm_test(resid(m_1), resid(m_2))

# Test independence of a functional variable and a scalar variable given a
# functional variable
\donttest{
m_X <- pffr(X ~ ff(Z), data=ghcm_sim_data, chunk.size=31000)
ghcm_test(resid(m_X), resid(m_1))
}
# Test independence of two functional variables given a functional variable
\donttest{
m_W <- pffr(W ~ ff(Z), data=ghcm_sim_data, chunk.size=31000)
ghcm_test(resid(m_X), resid(m_W))
}
}
\references{
Please cite the following paper: Anton Rask Lundborg, Rajen D. Shah and
 Jonas Peters: "Conditional Independence Testing in Hilbert Spaces with
 Applications to Functional Data Analysis" https://arxiv.org/abs/2101.07108
}
