% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R, R/repo_create.R, R/repo_delete.R,
%   R/repo_exists.R, R/repo_is_template.R, R/repo_mirror.R,
%   R/repo_mirror_template.R, R/repo_rename.R, R/repo_set_template.R
\name{repo_core}
\alias{repo_core}
\alias{repo_create}
\alias{repo_delete}
\alias{repo_exists}
\alias{repo_is_template}
\alias{repo_mirror}
\alias{repo_mirror_template}
\alias{repo_rename}
\alias{repo_set_template}
\title{GitHub Repository tools - core functions}
\usage{
repo_create(
  org,
  name,
  prefix = "",
  suffix = "",
  private = TRUE,
  auto_init = FALSE,
  gitignore_template = "R"
)

repo_delete(repo, prompt = TRUE)

repo_exists(repo, strict = FALSE, quiet = FALSE)

repo_is_template(repo)

repo_mirror(
  source_repo,
  target_repo,
  overwrite = FALSE,
  verbose = FALSE,
  warn = TRUE
)

repo_mirror_template(source_repo, target_repo, private = TRUE)

repo_rename(repo, new_repo)

repo_set_template(repo, status = TRUE)
}
\arguments{
\item{org}{Character. Name of the GitHub organization.}

\item{name}{Character. One or more GitHub username or team name.}

\item{prefix}{Character. Common repository name prefix}

\item{suffix}{Character. Common repository name suffix}

\item{private}{Logical. Should the new repository be private or public.}

\item{auto_init}{Logical. Should the repository be initialized with a \code{README.md}.}

\item{gitignore_template}{Character. \code{.gitignore} language template to use.}

\item{repo}{Character. Address of repository in \code{owner/repo} format.}

\item{prompt}{Logical. Should the user be prompted before deleting repositories. Default \code{true}.}

\item{strict}{Logical. Should the old name of a renamed repositories be allowed.}

\item{quiet}{Logical. Should details on renamed repositories be printed.}

\item{source_repo}{Character. Address of template repository in \code{owner/name} format.}

\item{target_repo}{Character. One or more repository addresses in \code{owner/name} format.
Note when using template repos these new repositories must \emph{not} exist.}

\item{overwrite}{Logical. Should the target repositories be overwritten.}

\item{verbose}{Logical. Display verbose output.}

\item{warn}{Logical. Warn the user about the function being deprecated.}

\item{new_repo}{Character. New name of repository without the owner.}

\item{status}{Logical. Should the repository be set as a template repository}
}
\value{
\code{repo_create()} returns a character vector of created repos (in \code{owner/repo} format)

\code{repo_exists()} and \code{repo_is_template()} both return a logical vector.

All other functions invisibly return a list containing the results of the relevant GitHub API calls.
}
\description{
\itemize{
\item \code{repo_create()} - create a GitHub repository.
\item \code{repo_delete()} - delete a GitHub repository.
\item \code{repo_rename()} - rename a repository, note that renamed repositories retain their
unique identifier and can still be accessed via their old names due to
GitHub re-directing.
\item \code{repo_exists()} - returns \code{TRUE} if the GitHub repository exists. It will also print
a message if a repository has been renamed, unless \code{quiet = TRUE}.
\item \code{repo_mirror()} - mirror the content of a repository to another repository,
the target repo must already exist.
\item \code{repo_mirror_template()} - mirror the content of a source template repository to a new repository,
the target repo must \emph{not} already exist.
\item \code{repo_is_template()} - returns \code{TRUE} if a repository is a template repo.
\item \code{repo_set_template()} - change the template status of a repository.
}
}
\examples{
\dontrun{
repo_create("ghclass-test", "repo_test")

repo_exists("ghclass-test/repo_test")

repo_rename("ghclass-test/repo_test", "repo_test_new")


# The new repo exists
repo_exists("ghclass-test/repo_test_new")

# The old repo forwards to the new repo
repo_exists("ghclass-test/repo_test")


# Check for the redirect by setting `strict = TRUE`
repo_exists("ghclass-test/repo_test", strict = TRUE)


# The prefered way of copying a repo is by making the source a template
repo_is_template("ghclass-test/repo_test_new")

repo_set_template("ghclass-test/repo_test_new")

repo_is_template("ghclass-test/repo_test_new")


# Given a template repo we can then directly copy the repo on GitHub
repo_mirror_template("ghclass-test/repo_test_new", "ghclass-test/repo_test_copy")

repo_exists("ghclass-test/repo_test_copy")

# Cleanup
repo_delete(
 c("ghclass-test/repo_test_new",
   "ghclass-test/repo_test_copy"),
 prompt = FALSE
)

}


}
