% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/guide_axis.R
\name{add_axis}
\alias{add_axis}
\alias{hide_axis}
\title{Add a vega axis specification to a ggvis plot}
\usage{
add_axis(vis, type, scale = NULL, orient = NULL, title = NULL,
  title_offset = NULL, format = NULL, ticks = NULL, values = NULL,
  subdivide = NULL, tick_padding = NULL, tick_size_major = NULL,
  tick_size_minor = tick_size_major, tick_size_end = tick_size_major,
  offset = NULL, layer = "back", grid = TRUE, properties = NULL)

hide_axis(vis, scale)
}
\arguments{
\item{vis}{A ggvis object.}

\item{type}{The type of axis. Either x or y.}

\item{scale}{The name of the scale backing the axis component. Defaults to
the scale type - you will need to specify if you want (e.g.) a scale
for a secondary y-axis.}

\item{orient}{The orientation of the axis. One of top, bottom, left or right.
The orientation can be used to further specialize the axis type (e.g., a y
axis oriented for the right edge of the chart) - defaults to bottom for
x axes, and left for y axes.}

\item{title}{A title for the axis. By default, it uses the name of the field
in the first data set used by the scale. Use \code{""} to suppress the
title.}

\item{title_offset}{The offset (in pixels) from the axis at which to place
the title.}

\item{format}{The formatting pattern for axis labels. Vega uses D3's format
pattern: \url{https://github.com/mbostock/d3/wiki/Formatting}}

\item{ticks}{A desired number of ticks. The resulting number may be different
so that values are "nice" (multiples of 2, 5, 10) and lie within the
underlying scale's range.}

\item{values}{Explicitly set the visible axis tick values.}

\item{subdivide}{If provided, sets the number of minor ticks between major
ticks (the value 9 results in decimal subdivision).}

\item{tick_padding}{The padding, in pixels, between ticks and text labels.}

\item{tick_size_major,tick_size_minor,tick_size_end}{The size, in pixels, of major, minor and end ticks.}

\item{offset}{The offset, in pixels, by which to displace the axis from the
edge of the enclosing group or data rectangle.}

\item{layer}{A string indicating if the axis (and any gridlines) should be
placed above or below the data marks. One of "front" or "back" (default).}

\item{grid}{A flag indicating if gridlines should be created in addition to
ticks.}

\item{properties}{Optional mark property definitions for custom axis styling.
Should be an object created by \code{\link{axis_props}}, with properties
for ticks, majorTicks, minorTicks, grid, labels, title, and axis.}
}
\description{
Axis specifications allow you to either override the default axes,
or additional axes.
}
\details{
More information about axes can be found in the "axes and legends" vignettes.
}
\section{Compared to ggplot2}{


In ggplot2, axis (and legend) properties are part of the scales
specification. In vega, they are separate, which allows the specification
of multiple axes, and more flexible linkage between scales and axes.
}
\examples{
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~cyl) \%>\%
  layer_points() \%>\%
  add_axis("x", title = "Weight", orient = "top")

# Suppress axis with hide_axis
mtcars \%>\% ggvis(x = ~wt, y = ~mpg, fill = ~cyl) \%>\%
  layer_points() \%>\%
  hide_axis("x") \%>\% hide_axis("y")

mtcars \%>\% ggvis(x = ~wt, y = ~mpg) \%>\% layer_points() \%>\%
  add_axis("x", title = "Weight", ticks = 40,
    properties = axis_props(
      ticks = list(stroke = "red"),
      majorTicks = list(strokeWidth = 2),
      grid = list(stroke = "red"),
      labels = list(
        fill = "steelblue",
        angle = 50,
        fontSize = 14,
        align = "left",
        baseline = "middle",
        dx = 3
      ),
      title = list(fontSize = 16),
      axis = list(stroke = "#333", strokeWidth = 1.5)
    )
  )
}
\seealso{
Vega axis documentation:
  \url{https://github.com/trifacta/vega/wiki/Axes}
}

