% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element-textbox.R
\name{element_textbox}
\alias{element_textbox}
\alias{element_textbox_simple}
\title{Theme element that enables markdown text in a box.}
\usage{
element_textbox(
  family = NULL,
  face = NULL,
  size = NULL,
  colour = NULL,
  fill = NULL,
  box.colour = NULL,
  linetype = NULL,
  linewidth = NULL,
  hjust = NULL,
  vjust = NULL,
  halign = NULL,
  valign = NULL,
  lineheight = NULL,
  margin = NULL,
  padding = NULL,
  width = NULL,
  height = NULL,
  minwidth = NULL,
  maxwidth = NULL,
  minheight = NULL,
  maxheight = NULL,
  r = NULL,
  orientation = NULL,
  color = NULL,
  box.color = NULL,
  debug = FALSE,
  inherit.blank = FALSE
)

element_textbox_simple(
  family = NULL,
  face = NULL,
  size = NULL,
  colour = NULL,
  fill = NA,
  box.colour = NULL,
  linetype = 0,
  linewidth = 0.5,
  hjust = 0.5,
  vjust = 0.5,
  halign = 0,
  valign = 1,
  lineheight = 1.2,
  margin = ggplot2::margin(0, 0, 0, 0),
  padding = ggplot2::margin(0, 0, 0, 0),
  width = grid::unit(1, "npc"),
  height = NULL,
  minwidth = NULL,
  maxwidth = NULL,
  minheight = NULL,
  maxheight = NULL,
  r = grid::unit(0, "pt"),
  orientation = "upright",
  color = NULL,
  box.color = NULL,
  debug = FALSE,
  inherit.blank = FALSE
)
}
\arguments{
\item{family}{Font family}

\item{face}{Font face}

\item{size}{Font size (in pt)}

\item{colour, color}{Text color}

\item{fill}{Fill color of the enclosing box}

\item{box.colour, box.color}{Line color of the enclosing box (if different from the text color)}

\item{linetype}{Line type of the enclosing box (like \code{lty} in base R)}

\item{linewidth}{Line width of the enclosing box (measured in mm, just like \code{size} in
\code{\link[ggplot2:element_line]{ggplot2::element_line()}}).}

\item{hjust}{Horizontal justification}

\item{vjust}{Vertical justification}

\item{halign}{Horizontal justification}

\item{valign}{Vertical justification}

\item{lineheight}{Line height, in multiples of the font size}

\item{padding, margin}{Padding and margins around the text box.
See \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}} for details.}

\item{width, height}{Unit objects specifying the width and height
of the textbox, as in \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}}.}

\item{minwidth, minheight, maxwidth, maxheight}{Min and max values for width and height.
Set to NULL to impose neither a minimum nor a maximum.}

\item{r}{Unit value specifying the corner radius of the box}

\item{orientation}{Orientation of the text box. See \code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}} for details.}

\item{debug}{Not implemented.}

\item{inherit.blank}{See \code{\link[ggplot2:margin]{ggplot2::margin()}} for details.}
}
\value{
A ggplot2 theme element that can be used inside a \code{\link[ggplot2:theme]{ggplot2::theme()}}
call.
}
\description{
The theme elements \code{element_textbox()} and \code{element_textbox_simple()} enable Markdown text in a box, with
word wrap. Both functions implement exactly the same functionality; they only differ in the default values
for the various element values. \code{element_textbox()} sets all values that are not specified to \code{NULL}, as is
the usual practice in ggplot2 themes. These missing values are usually completed by inheritance from
parent theme elements. By contrast, \code{element_textbox_simple()} provides meaningful default values for many of
the values that are not usually defined in ggplot2 themes. This makes it simpler to use a textbox element
in the context of an existing theme.
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(disp, mpg)) + 
geom_point() +
  labs(
    title =
    "<b><span style = 'font-size:13pt'>Fuel economy vs. engine displacement</span></b><br>
    Lorem ipsum *dolor sit amet,* consectetur adipiscing elit, **sed do eiusmod tempor
    incididunt** ut labore et dolore magna aliqua. <span style = 'color:red;'>Ut enim ad
    minim veniam,</span> quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea
    commodo consequat.",
    x = "displacement (in<sup>3</sup>)",
    y = "Miles per gallon (mpg)<br><span style = 'font-size:8pt'>A measure of
    the car's fuel efficiency.</span>"
  ) +
  theme(
    plot.title.position = "plot",
    plot.title = element_textbox_simple(
      size = 10,
      padding = margin(5.5, 5.5, 5.5, 5.5),
      margin = margin(0, 0, 5.5, 0),
      fill = "cornsilk"
    ),
    axis.title.x = element_textbox_simple(
      width = NULL,
      padding = margin(4, 4, 4, 4),
      margin = margin(4, 0, 0, 0),
      linetype = 1,
      r = grid::unit(8, "pt"),
      fill = "azure1"
    ),
    axis.title.y = element_textbox_simple(
      hjust = 0,
      orientation = "left-rotated",
      minwidth = unit(1, "in"),
      maxwidth = unit(2, "in"),
      padding = margin(4, 4, 2, 4),
      margin = margin(0, 0, 2, 0),
      fill = "lightsteelblue1"
    )
  )
}
\seealso{
\code{\link[gridtext:textbox_grob]{gridtext::textbox_grob()}}, \code{\link[=element_markdown]{element_markdown()}}, \code{\link[=geom_textbox]{geom_textbox()}}
}
