% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggpiestats.R
\name{grouped_ggpiestats}
\alias{grouped_ggpiestats}
\title{Grouped pie charts with statistical tests}
\usage{
grouped_ggpiestats(
  data,
  main,
  condition = NULL,
  counts = NULL,
  grouping.var,
  title.prefix = NULL,
  output = "plot",
  x = NULL,
  y = NULL,
  ...,
  plotgrid.args = list(),
  title.text = NULL,
  title.args = list(size = 16, fontface = "bold"),
  caption.text = NULL,
  caption.args = list(size = 10),
  sub.text = NULL,
  sub.args = list(size = 12)
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{main}{The variable to use as the \strong{rows} in the contingency table.}

\item{condition}{The variable to use as the \strong{columns} in the contingency
table. Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness
of fit test) will be run for the \code{x} variable. Otherwise an appropriate
association test will be run. This argument can not be \code{NULL} for
\code{ggbarstats} function.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation (Default).}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"} or \code{"h0"}),
which will return expression with evidence in favor of the null hypothesis,
or \code{"alternative"} (or \code{"title"} or \code{"H1"} or \code{"h1"}), which will return
expression with evidence in favor of the alternative hypothesis, or
\code{"results"}, which will return a dataframe with results all the details).}

\item{x}{The variable to use as the \strong{rows} in the contingency table.}

\item{y}{The variable to use as the \strong{columns} in the contingency
table. Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness
of fit test) will be run for the \code{x} variable. Otherwise an appropriate
association test will be run. This argument can not be \code{NULL} for
\code{ggbarstats} function.}

\item{...}{
  Arguments passed on to \code{\link[=ggpiestats]{ggpiestats}}
  \describe{
    \item{\code{factor.levels}}{A character vector with labels for factor levels of
\code{main} variable.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{palette}}{If a character string (e.g., \code{"Set1"}), will use that named
palette. If a number, will index into the list of palettes of appropriate
type. Default palette is \code{"Dark2"}.}
    \item{\code{proportion.test}}{Decides whether proportion test for \code{main} variable is
to be carried out for each level of \code{condition} (Default: \code{TRUE}).}
    \item{\code{perc.k}}{Numeric that decides number of decimal places for percentage
labels (Default: \code{0}).}
    \item{\code{label}}{Character decides what information needs to be displayed
on the label in each pie slice. Possible options are \code{"percentage"}
(default), \code{"counts"}, \code{"both"}.}
    \item{\code{label.args}}{Additional aesthetic arguments that will be passed to
\code{geom_label}.}
    \item{\code{bf.message}}{Logical that decides whether to display a caption with
results from Bayes Factor test in favor of the null hypothesis (default:
\code{FALSE}).}
    \item{\code{ratio}}{A vector of proportions: the expected proportions for the
proportion test (should sum to 1). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
This means if there are two levels this will be \code{ratio = c(0.5,0.5)} or if
there are four levels this will be \code{ratio = c(0.25,0.25,0.25,0.25)}, etc.}
    \item{\code{sampling.plan}}{Character describing the sampling plan. Possible options
are \code{"indepMulti"} (independent multinomial; default), \code{"poisson"},
\code{"jointMulti"} (joint multinomial), \code{"hypergeom"} (hypergeometric). For
more, see \code{?BayesFactor::contingencyTableBF()}.}
    \item{\code{fixed.margin}}{For the independent multinomial sampling plan, which
margin is fixed (\code{"rows"} or \code{"cols"}). Defaults to \code{"rows"}.}
    \item{\code{prior.concentration}}{Specifies the prior concentration parameter, set
to \code{1} by default. It indexes the expected deviation from the null
hypothesis under the alternative, and corresponds to Gunel and Dickey's
(1974) \code{"a"} parameter.}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}
    \item{\code{paired}}{Logical indicating whether data came from a within-subjects or
repeated measures design study (Default: \code{FALSE}). If \code{TRUE}, McNemar's
test subtitle will be returned. If \code{FALSE}, Pearson's chi-square test will
be returned.}
    \item{\code{stat.title}}{Title for the effect being investigated with the chi-square
test. The default is \code{NULL}, i.e. no title will be added to describe the
effect being shown. An example of a \code{stat.title} argument will be something
like \code{"main x condition"} or \code{"interaction"}.}
    \item{\code{conf.level}}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}
    \item{\code{nboot}}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}
    \item{\code{legend.title}}{Title text for the legend.}
    \item{\code{messages}}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}
    \item{\code{package}}{Name of package from which the palette is desired as string
or symbol.}
    \item{\code{direction}}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}
  }}

\item{plotgrid.args}{A list of additional arguments to \code{cowplot::plot_grid}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.args}{A list of additional arguments
provided to \code{title}, \code{caption} and \code{sub}, resp.}
}
\value{
Unlike a number of statistical softwares, \code{ggstatsplot} doesn't
provide the option for Yates' correction for the Pearson's chi-squared
statistic. This is due to compelling amount of Monte-Carlo simulation
research which suggests that the Yates' correction is overly conservative,
even in small sample sizes. As such it is recommended that it should not
ever be applied in practice (Camilli & Hopkins, 1978, 1979; Feinberg, 1980;
Larntz, 1978; Thompson, 1988).

For more about how the effect size measures and their confidence intervals
are computed, see \code{?rcompanion::cohenG}, \code{?rcompanion::cramerV}, and
\code{?rcompanion::cramerVFit}.
}
\description{
Helper function for \code{ggstatsplot::ggpiestats} to apply this
function across multiple levels of a given factor and combining the
resulting plots using \code{ggstatsplot::combine_plots}.
}
\examples{
\donttest{
# grouped one-sample proportion tests
ggstatsplot::grouped_ggpiestats(
  data = mtcars,
  grouping.var = am,
  x = cyl
)

# the following will take slightly more amount of time
# for reproducibility
set.seed(123)

# let's create a smaller dataframe
diamonds_short <- ggplot2::diamonds \%>\%
  dplyr::filter(.data = ., cut \%in\% c("Fair", "Very Good", "Ideal")) \%>\%
  dplyr::sample_frac(tbl = ., size = 0.10)

# plot
ggstatsplot::grouped_ggpiestats(
  data = diamonds_short,
  x = color,
  y = clarity,
  grouping.var = cut,
  nboot = 20,
  sampling.plan = "poisson",
  title.prefix = "Quality",
  slice.label = "both",
  messages = FALSE,
  perc.k = 1,
  plotgrid.args = list(nrow = 3)
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggpiestats.html}
}
\seealso{
\code{\link{ggbarstats}}, \code{\link{ggpiestats}},
\code{\link{grouped_ggbarstats}}
}
