% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_anova_subtitles.R
\name{subtitle_friedman_nonparametric}
\alias{subtitle_friedman_nonparametric}
\title{Making text subtitle for the Friedman Rank Sum Test (nonparametric
ANOVA) (within-subjects designs).}
\usage{
subtitle_friedman_nonparametric(data, x, y, messages = TRUE, k = 2,
  ...)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (ignored).}
}
\description{
Making text subtitle for the Friedman Rank Sum Test (nonparametric
ANOVA) (within-subjects designs).
}
\examples{
# setup
set.seed(123)
library(ggstatsplot)
library(jmv)
data("bugs", package = "jmv")

# converting to long format
data_bugs <- bugs \%>\%
  tibble::as_tibble(.) \%>\%
  tidyr::gather(., key, value, LDLF:HDHF)

# creating the subtitle
ggstatsplot::subtitle_friedman_nonparametric(
  data = data_bugs,
  x = key,
  y = value,
  k = 2
)
}
\author{
Indrajeet Patil
}
