% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscatterstats.R
\name{ggscatterstats}
\alias{ggscatterstats}
\title{Scatterplot with marginal distributions}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{A vector containing the explanatory variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{xlab}{Label for \code{x} axis variable.}

\item{ylab}{Label for \code{y} axis variable.}

\item{line.colour}{Colour for the regression line.}

\item{marginal}{Decides whether \code{ggExtra::ggMarginal()} plots will be
displayed; the default is \code{TRUE}.}

\item{marginal.type}{Type of marginal distribution to be plotted on the axes
(\code{"histogram"}, \code{"boxplot"}, \code{"density"}, \code{"violin"}).}

\item{xfill}{Colour fill for x axis distibution (default: \code{"orange"}).}

\item{yfill}{Colour fill for y axis distribution (default: \code{"green"}).}

\item{type}{Type of association between paired samples required
("\code{"parametric"}: Pearson's product moment correlation coefficient" or
"\code{"nonparametric"}: Spearman's rho" or "\code{"robust"}: Robust regression using
an M estimator"). Corresponding abbreviations are also accepted: \code{"p"} (for
parametric/pearson's), \code{"np"} (nonparametric/spearman), \code{"r"} (robust),
resp.}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as subtitle.}

\item{centrality.para}{Decides \emph{which} measure of central tendency (\code{"mean"}
or \code{"median"}) is to be displayed as vertical (for \code{x}) and horizontal (for
\code{y}) lines.}

\item{title}{The text for the plot title.}

\item{caption}{The text for the plot caption.}

\item{maxit}{Maximum number of iterations for robust linear regression or
bootstrap samples to compute Spearman's rho confidence intervals (Default:
\code{500}).}

\item{k}{Number of decimal places expected for results.}

\item{width.jitter}{Degree of jitter in \code{x} direction. Defaults to 40\% of
the resolution of the data.}

\item{height.jitter}{Degree of jitter in \code{y} direction. Defaults to 40\% of
the resolution of the data.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Scatterplots from `ggplot2`` combined with add marginal
histograms/boxplots/density plots with statistical details added as a
subtitle.
}
\examples{

# to get reproducible results from bootstrapping
set.seed(123)

#' # simple function call with the defaults
ggstatsplot::ggscatterstats(
data = datasets::mtcars,
x = wt,
y = mpg
)

# more detailed function call
ggstatsplot::ggscatterstats(
data = datasets::iris,
x = Petal.Length,
y = Sepal.Length,
centrality.para = 'median',
type = 'robust',
marginal.type = 'density'
)

}
\author{
Indrajeet Patil
}
