% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-summaryh.R
\name{hmisc_h}
\alias{hmisc_h}
\alias{mean_cl_boot_h}
\alias{mean_cl_normal_h}
\alias{mean_sdl_h}
\alias{median_hilow_h}
\title{Horizontal versions of summary functions from Hmisc}
\usage{
mean_cl_boot_h(x, ...)

mean_cl_normal_h(x, ...)

mean_sdl_h(x, ...)

median_hilow_h(x, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{...}{other arguments passed on to the respective Hmisc function.}
}
\value{
A data frame with columns \code{x}, \code{xmin}, and \code{xmax}.
}
\description{
These are horizontal versions of the wrappers around functions from
\pkg{Hmisc} designed to make them easier to use with
\code{\link{stat_summaryh}}. The corresponding vertical versions are
\code{\link[ggplot2]{hmisc}()}. See the Hmisc documentation for more details:

\itemize{
 \item \code{\link[Hmisc]{smean.cl.boot}}
 \item \code{\link[Hmisc]{smean.cl.normal}}
 \item \code{\link[Hmisc]{smean.sdl}}
 \item \code{\link[Hmisc]{smedian.hilow}}
}
}
\examples{
if (requireNamespace("Hmisc")) {
  x <- rnorm(100)
  mean_cl_boot_h(x)
  mean_cl_normal_h(x)
  mean_sdl_h(x)
  median_hilow_h(x)
}
}
