% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-.R
\name{scale_discrete_manual}
\alias{scale_discrete_manual}
\title{Generic discrete manual scale}
\usage{
scale_discrete_manual(aesthetics, values, ...)
}
\arguments{
\item{aesthetics}{The aesthetics for which this scale should be used}

\item{values}{List of values to be used as palette}

\item{...}{Other parameters handed off to \link{discrete_scale}}
}
\description{
Generic discrete manual scale. This scale can be used to manually set the values
for any aesthetics, and it is equivalent to \code{\link[=scale_colour_manual]{scale_colour_manual()}}, \code{\link[=scale_fill_manual]{scale_fill_manual()}},
etc. For example, instead of writing \code{scale_colour_manual(values = c(...))}, we can
write \code{scale_discrete_manual("colour", values = c(...))}.
}
\examples{
library(ggplot2)

ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species)) +
  geom_density_ridges(aes(point_color = Species, point_fill = Species,
                          point_shape = Species),
                      alpha = .2, jittered_points = TRUE) +
  scale_fill_manual( values = c("#0072b2", "#D55E00", "#009e73")) +
  scale_discrete_manual("point_color", values = c("#0072b2", "#D55E00", "#009e73")) +
  scale_discrete_manual("point_fill", values = c("#0072b280", "#D55E0080", "#009e7380")) +
  scale_discrete_manual("point_shape", values = c(21, 22, 23)) +
  theme_ridges()
}
\seealso{
See \code{\link[=scale_point_color_hue]{scale_point_color_hue()}} for specific scales for point aesthetics and
\code{\link[=scale_vline_color_hue]{scale_vline_color_hue()}} for specific scales for vline aesthetics.
}
