% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-ma-line.R
\name{stat_ma_line}
\alias{stat_ma_line}
\title{Predicted line from major axis linear fit}
\usage{
stat_ma_line(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  ...,
  method = "MA",
  formula = NULL,
  range.y = NULL,
  range.x = NULL,
  se = TRUE,
  mf.values = FALSE,
  n = 80,
  nperm = 99,
  fullrange = FALSE,
  level = 0.95,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be set at the layer level if you
are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{method}{character "MA", "SMA" , "RMA" and "OLS".}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names.}

\item{range.y, range.x}{character Pass "relative" or "interval" if method
"RMA" is to be computed.}

\item{se}{logical Return confidence interval around smooth? (`TRUE` by
default, see `level` to control.)}

\item{mf.values}{logical Add R2, p-value and n as columns to returned data?
(`FALSE` by default.)}

\item{n}{Number of points at which to evaluate smoother.}

\item{nperm}{integer Number of permutation used to estimate significance.}

\item{fullrange}{Should the fit span the full range of the plot, or just
the data?}

\item{level}{Level of confidence interval to use (only 0.95 currently).}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The value returned by the statistic is a data frame, that will have
  \code{n} rows of predicted values and their confidence limits. Optionally
  it will also include additional values related to the model fit.
}
\description{
Predicted values and a confidence band are computed and, by default, plotted.
\code{stat_ma_line()} behaves similarly to \code{\link[ggplot2]{stat_smooth}}
except for fitting the model with \code{lmodel2::lmodel2()} with \code{"MA"}
as default for \code{method}.
}
\details{
This statistic fits major axis (\code{"MA"}) and other model II regressions
with function \code{\link[lmodel2]{lmodel2}}. Model II regression is called
for when both \code{x} and \code{y} are subject to random variation and the
intention is not to predict \code{y} from \code{x} by means of the model
but rather to study the relationship between two independent variables.
A frequent case in biology are allometric relationships among body parts.

As the fitted line is the same wheter \code{x} or \code{y} is on the rhs of
the model equation, \code{orientation} even is accepted does not have an
effect on the fit. In contrast, \code{\link[ggplot2]{geom_smooth}} treats
each axis differently and can thus have two orientations. The orientation is
easy to deduce from the argument passed to \code{formula}. Thus,
\code{stat_ma_line()} will by default guess which orientation the layer
should have. If no argument is passed to \code{formula}, the orientation can
be specified directly passing an argument to the \code{orientation}
parameter, which can be either \code{"x"} or \code{"y"}. The value gives the
axis that is on the rhs of the model equation, \code{"x"} being the default
orientation. Package 'ggpmisc' does not define new geometries matching the
new statistics as they are not needed and conceptually transformations of
\code{data} are expressed as statistics.
}
\section{Computed variables}{
 `stat_ma_line()` provides the following
  variables, some of which depend on the orientation: \describe{ \item{y *or*
  x}{predicted value} \item{ymin *or* xmin}{lower pointwise confidence
  interval around the mean} \item{ymax *or* xmax}{upper pointwise confidence
  interval around the mean} \item{se}{standard error} }

  If \code{mf.values = TRUE} is passed then columns based on the summary of
  the model fit are added, with the same value in each row within a group.
  This is wasteful and disabled by default, but provides a simple and robust
  approach to achieve effects like colouring or hiding of the model fit line
  based on P-values, r-squared or the number of observations.
}

\section{Aesthetics}{
 \code{stat_ma_line} understands \code{x} and \code{y},
  to be referenced in the \code{formula}. Both must be mapped to
  \code{numeric} variables. In addition, the aesthetics understood by the
  geom (\code{"geom_smooth"} is the default) are understood and grouping
  respected.
}

\examples{
# generate artificial data
set.seed(98723)
my.data <- data.frame(x = rnorm(100) + (0:99) / 10 - 5,
                      y = rnorm(100) + (0:99) / 10 - 5,
                      group = c("A", "B"))

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line()

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "MA")

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "SMA")

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "RMA",
               range.y = "interval", range.x = "interval")

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "OLS")

# plot line to the ends of range of data (the default)
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(fullrange = FALSE) +
  expand_limits(x = c(-10, 10), y = c(-10, 10))

# plot line to the limits of the scales
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(fullrange = TRUE) +
  expand_limits(x = c(-10, 10), y = c(-10, 10))

# plot line to the limits of the scales
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(orientation = "y", fullrange = TRUE) +
  expand_limits(x = c(-10, 10), y = c(-10, 10))

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(formula = x ~ y)

# Smooths are automatically fit to each group (defined by categorical
# aesthetics or the group aesthetic) and for each facet.

ggplot(my.data, aes(x, y, colour = group)) +
  geom_point() +
  stat_ma_line()

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line() +
  facet_wrap(~group)

# Inspecting the returned data using geom_debug()
\dontrun{
if (requireNamespace("gginnards", quietly = TRUE)) {
  library(gginnards)

  ggplot(my.data, aes(x, y)) +
    stat_ma_line(geom = "debug")

  ggplot(my.data, aes(x, y)) +
    stat_ma_line(geom = "debug", mf.values = TRUE)

}
}

}
\seealso{
Other ggplot statistics for major axis regression: 
\code{\link{stat_ma_eq}()}
}
\concept{ggplot statistics for major axis regression}
