% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_div}
\alias{ggml_div}
\title{Element-wise Division (Graph)}
\usage{
ggml_div(ctx, a, b)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{First tensor (numerator)}

\item{b}{Second tensor (denominator, same shape as a)}
}
\value{
Tensor representing the division operation (a / b)
}
\description{
Creates a graph node for element-wise division.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
b <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(10, 20, 30, 40, 50))
ggml_set_f32(b, c(2, 2, 2, 2, 2))
result <- ggml_div(ctx, a, b)
graph <- ggml_build_forward_expand(ctx, result)
ggml_graph_compute(ctx, graph)
ggml_get_f32(result)
ggml_free(ctx)
}
}
