% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.r
\docType{data}
\name{position_logo}
\alias{position_logo}
\alias{PositionLogo}
\alias{position_classic}
\alias{PositionClassic}
\title{Logo positioning for overlapping objects on top of one another.}
\usage{
position_logo()

position_classic()
}
\description{
\code{position_classic} is stacking objects in an ordered fashion from largest to smallest element,
\code{position_logo} reverses the classic order and additionally shifts stacks downward to align the largest objects along their vertical minimum,
\code{position_fill} additionally standardises each stack to have unit
height.
}
\examples{
\donttest{
library(ggplot2)
data(sequences)

# to make the most of comparisons, largest letters ar aligned along their minimum to
# work out the main sequence.
ggplot(data = ggfortify(sequences, "peptide", treatment = "class")) +
  geom_logo(aes(x = class, y = bits, fill = Water, label = element), position="logo") + 
  facet_wrap(~position)

# in the classic logo plots letters are stacked in an ordered fasahion on top of each other
ggplot(data = ggfortify(sequences, "peptide", treatment = "class")) +
  geom_logo(aes(x = class, y = bits, fill = Water, label = element), position="classic") + 
  facet_wrap(~position)
}
}
\seealso{
See \code{\link{geom_logo}} for
  more examples.
}
\keyword{datasets}
