% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_scalebar.R
\name{guide_axis_scalebar}
\alias{guide_axis_scalebar}
\title{Scale bar axis guide}
\usage{
guide_axis_scalebar(
  title = waiver(),
  size = NULL,
  label = NULL,
  colour = NULL,
  color = NULL,
  just = 1,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{size}{A \code{numeric(1)} for a distance to indicate, in data units. If
\code{NULL} (default), the median distance between breaks is taken.}

\item{label}{A \code{character(1)} to use as scale bar label. If \code{NULL} (default),
the \code{size} distance is fed to the scale's labeller.}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{just}{A \code{numeric(1)} between 0 and 1 to indicate where the scalebar
should be drawn relative to the plot panel. The default (1), places is
at the right or at the top.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\value{
A \code{axis_scalebar} guide class object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
This axis guides draws a scale bar to indicate a distance rather than
mark absolute values.
The function is questioned due to
a possible migration of guide functions after ggplot2 releases a new guide
system.
}
\details{
It is discouraged to use this guide in combination with a scale
transformation.
}
\section{Theme elements}{

This axis guide has an alternative understanding of the following theme
elements:

\describe{
\item{\verb{axis.ticks.*}}{
An \code{element_line()} to draw the scale bar itself.
}
\item{\verb{axis.ticks.length.*}}{
A \code{unit()} indicating how far the scale bar should be placed from the
plot panel. Can be a negative unit to place the scale bar inside the
plot panel.
}
\item{\verb{axis.text.*}}{
The \code{hjust} and \code{vjust} parameters are used to justify the text along
the scale bar, instead of along itself, in the \code{x} and \code{y} directions
respectively.
}
}
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Guide as secondary axis
p + guides(x.sec = "axis_scalebar")

# Customising size and label
p + guides(x.sec = guide_axis_scalebar(size = 0.5, label = "0.5 litre"))

# Placing the scale bar on top of the plotting panel
p + guides(x.sec = guide_axis_scalebar(just = 0.95)) +
  theme(axis.ticks.length.x.top = unit(-2, "lines"))

# Adding arrows through the axis.ticks theme element
p + guides(y.sec = guide_axis_scalebar(size = 10, label = "10\nmpg")) +
  theme(axis.ticks.y.right = element_line(arrow = arrow(ends = "both")))
}
\seealso{
Other axis-guides: 
\code{\link{guide_axis_logticks}()},
\code{\link{guide_axis_manual}()},
\code{\link{guide_axis_minor}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_axis_truncated}()}
}
\concept{axis-guides}
