% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_difference.R
\name{stat_difference}
\alias{stat_difference}
\title{Difference ribbon}
\usage{
stat_difference(
  mapping = NULL,
  data = NULL,
  geom = "ribbon",
  position = "identity",
  ...,
  levels = c("+", "-", "0"),
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{geom_ribbon()} and \code{stat_difference()}.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{levels}{A \code{character(3)} indicating factor levels for the \code{fill}
aesthetic for the following cases (1) \code{max > min} (2) \code{max < min}
(3) \code{max == min}. Will be padded with \code{NA}s when necessary.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \code{Layer} object that can be added to a plot.
}
\description{
This makes a ribbon that is filled depending on whether the \code{max} is
higher than \code{min}. This can be useful for displaying differences
between two series.
}
\details{
The stat may reorder the \code{group} aesthetic to accommodate two
different fills for the signs of differences. The stat takes care to
interpolate a series whenever a crossover between \code{max} and \code{min} series
happens. This makes the ribbon not look stumpy at these crossovers.
}
\section{Aesthetics}{

\code{geom_ribbon()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x} \emph{or} \code{y}}
\item \strong{\code{ymin} \emph{or} \code{xmin}}
\item \strong{\code{ymax} \emph{or} \code{xmax}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{linetype}
\item \code{linewidth}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.
}

\section{Computed variables}{
 \describe{
\item{\code{sign}}{A \code{factor} with the \code{levels} attribute set to the \code{levels}
argument.}
}
}

\examples{
set.seed(2021)
df <- data.frame(
  x = 1:100,
  y = cumsum(rnorm(100)),
  z = cumsum(rnorm(100))
)

ggplot(df, aes(x = x)) +
  stat_difference(aes(ymin = y, ymax = z), alpha = 0.3) +
  geom_line(aes(y = y, colour = "min")) +
  geom_line(aes(y = z, colour = "max"))
}
