% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_nested_wrap.R
\name{facet_nested_wrap}
\alias{facet_nested_wrap}
\title{Ribbon of panels with nested strips.}
\usage{
facet_nested_wrap(
  facets,
  nrow = NULL,
  ncol = NULL,
  scales = "fixed",
  axes = "margins",
  remove_labels = "none",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  drop = TRUE,
  dir = "h",
  strip.position = "top",
  nest_line = FALSE,
  resect = unit(0, "mm"),
  bleed = FALSE
)
}
\arguments{
\item{facets}{A set of variables or expressions quoted by \code{\link[ggplot2:vars]{vars()}}
and defining faceting groups on the rows or columns dimension.
The variables can be named (the names are passed to \code{labeller}).

For compatibility with the classic interface, can also be a
formula or character vector. Use either a one sided formula, \code{~a + b},
or a character vector, \code{c("a", "b")}.}

\item{nrow}{Number of rows and columns.}

\item{ncol}{Number of rows and columns.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{axes}{A \code{character} where axes should be drawn. Either
\code{"margins"} (default), \code{"rows"}, \code{"cols"} or \code{"full"}.
Only applies when the scale is free through the \code{scales} argument.}

\item{remove_labels}{A \code{character} denoting what labels should be
removed when axes are repeated and redundant. Either \code{"none"}
(default), \code{"rows"}, \code{"cols"} or \code{"all"}. Only applies to
relevant position guides included with the \code{axes} argument when scales
are fixed.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:labellers]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:labellers]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{dir}{Direction: either \code{"h"} for horizontal, the default, or \code{"v"},
for vertical.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}

\item{nest_line}{a \code{logical} vector of length 1, indicating whether to
draw a nesting line to indicate the nesting of variables. Control the look
of the nesting line by setting the \code{ggh4x.facet.nestline} theme
element.}

\item{resect}{a \code{unit} vector of length 1, indicating how much the
nesting line should be shortened.}

\item{bleed}{a \code{logical} vector of length 1, indicating whether merging
of lower-level variables is allowed when the higher-level variables are
separate. See details.}
}
\value{
A \code{FacetNestedWrap} ggproto object that can be added to a plot.
}
\description{
\code{facet_nested_wrap()} wraps a sequence of panels onto a two-dimensional
layout, and nests grouped facets where possible.
}
\details{
This function inherits the capabilities of
  \code{\link[ggh4x]{facet_wrap2}()}.

  This function only merges strips in the same row or column as they appear
  through regular \code{facet_wrap()} layout behaviour.

  Hierarchies are inferred from the order of variables supplied to
  \code{rows} or \code{cols}. The first variable is interpreted to be the
  outermost variable, while the last variable is interpreted to be the
  innermost variable. They display order is always such that the outermost
  variable is placed the furthest away from the panels. Strips are
  automatically grouped when they span a nested variable.

  The \code{bleed} argument controls whether lower-level variables are allowed
  to be merged when higher-level are different, i.e. they can bleed over
  hierarchies. Suppose the \code{facet_wrap()} behaviour would be the
  following:

  \code{[_1_][_2_][_2_]} \cr \code{[_3_][_3_][_4_]}

  In such case, the default \code{bleed = FALSE} argument would result in the
  following:

  \code{[_1_][___2____]} \cr \code{[_3_][_3_][_4_]}

  Whereas \code{bleed = TRUE} would allow the following:

  \code{[_1_][___2____]} \cr \code{[___3____][_4_]}
}
\examples{
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()
p + facet_nested_wrap(vars(cyl, drv))

# Controlling the nest line
p + facet_nested_wrap(vars(cyl, drv), nest_line = TRUE) +
  theme(ggh4x.facet.nestline = element_line(linetype = 3))

# Ignore nested hierarchies with the 'bleed' argument
 p + facet_nested_wrap(vars(drv, cyl), bleed = TRUE)
}
\seealso{
Other facetting functions: 
\code{\link{facet_nested}()},
\code{\link{facet_wrap2}()}
}
\concept{facetting functions}
