% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{emale_genes}
\alias{emale_genes}
\title{Gene annotations if 6 EMALE genomes (endogenous virophages)}
\format{
A data frame with 143 rows and 17 columns
\describe{
\item{file_id}{name of the file the data was read from}
\item{seq_id}{identifier of the sequence the feature appears on}
\item{start}{start of the feature on the sequence}
\item{end}{end of the feature on the sequence}
\item{strand}{reading orientation relative to sequence (+ or -)}
\item{type}{feature type (CDS, mRNA, gene, ...)}
\item{feat_id}{unique identifier of the feature}
\item{introns}{a list column with internal intron start/end positions}
\item{parent_ids}{a list column with parent IDs - feat_id's of parent features}
\item{source}{source of the annotation}
\item{score}{score of the annotation}
\item{phase}{For "CDS" features indicates where the next codon begins relative to the 5' start}
\item{width}{width of the feature}
\item{gc_content}{relative GC-content of the feature}
\item{name}{name of the feature}
\item{Note}{}
\item{geom_id}{an identifier telling the which features should be plotted as on items (usually CDS and mRNA of same gene)}
}
}
\source{
\itemize{
\item Publication: \doi{10.1101/2020.11.30.404863}
\item Raw data: \url{https://github.com/thackl/cb-emales}
\item Derived & bundled data: \code{ex("emales/emales.gff")}
}
}
\usage{
emale_genes
}
\description{
A data set containing gene feature annotations for 6 endogenous virophages
found in the genomes of the marine protist \emph{Cafeteria burkhardae}.
}
\keyword{datasets}
