% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotlib.R
\name{post_autoplot}
\alias{post_autoplot}
\title{Post process for fortify. Based on \code{ggplot2::qplot}}
\usage{
post_autoplot(p, xlim = c(NA, NA), ylim = c(NA, NA), log = "",
  main = NULL, xlab = NULL, ylab = NULL, asp = NULL)
}
\arguments{
\item{p}{\code{ggplot2::ggplot} instances}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}
}
\value{
data.frame
}
\description{
Post process for fortify. Based on \code{ggplot2::qplot}
}
\examples{
p <- qplot(Petal.Length, Petal.Width, data = iris)
ggfortify:::post_autoplot(p, xlim = c(1, 5), ylim = c(1, 5), log = 'xy', main = 'title',
                          xlab = 'x', ylab = 'y', asp = 1.5)
}

