% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{summed_log_prior}
\alias{summed_log_prior}
\title{Sum and Log Prior Density of a EAM model}
\usage{
summed_log_prior(pVec, pPrior)
}
\arguments{
\item{pVec}{a parameter vector}

\item{pPrior}{p.prior}
}
\description{
Get log likelihood summed over all prior parameters
}
\examples{
pVec <- c(a=1, v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)

p.prior  <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05) * 5,
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

summed_log_prior(pVec, p.prior)
## -3.224406
}

