% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{RankCorr}
\alias{RankCorr}
\alias{RankCorr_u_tau}
\title{Thinned subset of posterior sample from a Bayesian analysis of perception of correlation.}
\description{
Data from Kay and Heer (2016), primarily used for testing and examples.
}
\details{
For more details, see Kay and Heer (2016) or the Github repository describing the analysis:
\url{https://github.com/mjskay/ranking-correlation}. The original experiment (but not this analysis of it)
is described in Harrison \emph{et al.} (2014).

\code{data("RankCorr")} is a substantially thinned version of the original posterior sample and has omitted several
parameters in order for it to be a more manageable size.

\code{data("RankCorr_u_tau")} is used for testing and examples and is roughly the equivalent of the following:

\if{html}{\out{<div class="sourceCode">}}\preformatted{data("RankCorr")
RankCorr_u_tau = tidybayes::spread_draws(RankCorr, u_tau[i]))
}\if{html}{\out{</div>}}
}
\references{
Kay, Matthew, and Jeffrey Heer. (2016).
"Beyond Weber's law: A second look at ranking visualizations of correlation."
\emph{IEEE transactions on visualization and computer graphics} 22(1): 469-478.
\doi{10.1109/TVCG.2015.2467671}

Harrison, Lane, Fumeng Yang, Steven Franconeri, and Remco Chang. (2014).
"Ranking visualizations of correlation using Weber's law."
\emph{IEEE transactions on visualization and computer graphics} 20(12): 1943-1952.
\doi{10.1109/TVCG.2014.2346979}
}
\keyword{datasets}
\keyword{internal}
