% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colliders.R
\name{Test if Variable Is Collider}
\alias{Test if Variable Is Collider}
\alias{is_collider}
\alias{is_downstream_collider}
\title{Detecting colliders in DAGs}
\usage{
is_collider(.dag, .var, downstream = TRUE)

is_downstream_collider(.dag, .var)
}
\arguments{
\item{.dag}{an input graph, an object of class \code{tidy_dagitty} or \code{dagitty}}

\item{.var}{a character vector of length 1, the potential collider to check}

\item{downstream}{Logical. Check for downstream colliders? Default is \code{TRUE}.}
}
\value{
Logical. Is the variable a collider or downstream collider?
}
\description{
Detecting colliders in DAGs
}
\examples{
dag <- dagify(m ~ x + y, m_jr ~ m)
is_collider(dag, "m")
is_downstream_collider(dag, "m_jr")

#  a downstream collider is also treated as a collider
is_collider(dag, "m_jr")

#  but a direct collider is not treated as a downstream collider
is_downstream_collider(dag, "m")

}
