% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment_sets.R
\name{Covariate Adjustment Sets}
\alias{Covariate Adjustment Sets}
\alias{dag_adjustment_sets}
\alias{ggdag_adjustment_set}
\title{Covariate Adjustment Sets}
\usage{
dag_adjustment_sets(.tdy_dag, exposure = NULL, outcome = NULL, ...)

ggdag_adjustment_set(.tdy_dag, exposure = NULL, outcome = NULL, ...,
  shadow = FALSE, node_size = 16, text_size = 3.88,
  label_size = text_size, text_col = "white", label_col = text_col,
  node = TRUE, stylized = FALSE, text = TRUE, use_labels = NULL,
  expand_x = expand_scale(c(0.25, 0.25)),
  expand_y = expand_scale(c(0.2, 0.2)))
}
\arguments{
\item{.tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{exposure}{a character vector, the exposure variable. Default is
\code{NULL}, in which case it will be determined from the DAG.}

\item{outcome}{a character vector, the outcome variable. Default is
\code{NULL}, in which case it will be determined from the DAG.}

\item{...}{additional arguments to \code{adjustmentSets}}

\item{shadow}{logical. Show paths blocked by adjustment?}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_repel_label()}.
Default is \code{NULL}.}

\item{expand_x, expand_y}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance away
from the axes. Use the convenience function \code{expand_scale()} to
generate the values for the expand argument.}
}
\value{
a \code{tidy_dagitty} with an \code{adjusted} column and \code{set}
column, indicating adjustment status and DAG ID, respectively, for the
adjustment sets or a \code{ggplot}
}
\description{
See \code{\link[dagitty:adjustmentSets]{dagitty::adjustmentSets()}} for details.
}
\examples{
dag <- dagify(y ~ x + z2 + w2 + w1,
  x ~ z1 + w1,
  z1 ~ w1 + v,
  z2 ~ w2 + v,
  w1 ~~ w2,
  exposure = "x",
  outcome = "y")

tidy_dagitty(dag) \%>\% dag_adjustment_sets()

ggdag_adjustment_set(dag)

ggdag_adjustment_set(dagitty::randomDAG(10, .5),
  exposure = "x3",
  outcome = "x5")

}
