% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-beeswarm.R
\name{position_beeswarm}
\alias{position_beeswarm}
\title{Violin point-style plots to show overlapping points. x must be discrete.}
\usage{
position_beeswarm(priority = c("ascending", "descending", "density", "random",
  "none"), cex = 1, groupOnX = NULL, dodge.width = 0)
}
\arguments{
\item{priority}{Method used to perform point layout (see \code{\link{swarmx}})}

\item{cex}{Scaling for adjusting point spacing (see \code{\link{swarmx}})}

\item{groupOnX}{should jitter be added to the x axis if TRUE or y axis if FALSE (the default NULL causes the function to guess which axis is the categorical one based on the number of unique entries in each)}

\item{dodge.width}{Amount by which points from different aesthetic groups will be dodged. This requires that one of the aesthetics is a factor.}
}
\description{
Violin point-style plots to show overlapping points. x must be discrete.
}
\examples{

  ggplot2::qplot(class, hwy, data = ggplot2::mpg, geom='beeswarm')
  # Generate fake data
  distro <- data.frame(
    'variable'=rep(c('runif','rnorm'),each=100),
    'value'=c(runif(100, min=-3, max=3), rnorm(100))
  )
  ggplot2::qplot(variable, value, data = distro, geom='beeswarm')
  ggplot2::qplot(variable, value, data = distro) +
    geom_beeswarm(priority='density',cex=2.5)

}
\seealso{
\code{\link{position_quasirandom}}, \code{\link[beeswarm]{swarmx}}

Other position.adjustments: \code{\link{position_quasirandom}}
}

