% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-helper.R
\name{element_curve}
\alias{element_curve}
\title{Theme curve elements}
\usage{
element_curve(
  colour = NULL,
  linewidth = NULL,
  linetype = NULL,
  lineend = NULL,
  color = NULL,
  curvature = NULL,
  angle = NULL,
  ncp = NULL,
  shape = NULL,
  arrow = NULL,
  arrow.fill = NULL,
  inherit.blank = FALSE
)
}
\arguments{
\item{colour, color}{Line/border colour. Color is an alias for colour.}

\item{linewidth}{Line/border size in mm.}

\item{linetype}{Line type. An integer (0:8), a name (blank, solid,
dashed, dotted, dotdash, longdash, twodash), or a string with
an even number (up to eight) of hexadecimal digits which give the
lengths in consecutive positions in the string.}

\item{lineend}{Line end Line end style (round, butt, square)}

\item{curvature}{A numeric value giving the amount of curvature.
    Negative values produce left-hand curves, positive values
    produce right-hand curves, and zero produces a straight line.}

\item{angle}{A numeric value between 0 and 180,
    giving an amount to skew the control
    points of the curve.  Values less than 90 skew the curve towards
    the start point and values greater than 90 skew the curve
    towards the end point.}

\item{ncp}{The number of control points used to draw the curve.
    More control points creates a smoother curve.}

\item{shape}{A numeric vector of values between -1 and 1, which
    control the shape of the curve relative to its control points.
    See \code{grid.xspline} for more details.}

\item{arrow}{A list describing arrow heads to place at either end
    of the curve, as produced by the \code{arrow} function.}

\item{arrow.fill}{Fill colour for arrows.}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}
}
\value{
A \code{element_curve} object
}
\description{
Draw curve.
}
