% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-panel.R
\name{align_panel}
\alias{align_panel}
\alias{ggpanel}
\title{Create ggplot object with layout panel data}
\usage{
align_panel(
  mapping = aes(),
  size = NULL,
  free_labs = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL
)

ggpanel(
  mapping = aes(),
  size = NULL,
  free_labs = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  limits = TRUE,
  facet = TRUE,
  set_context = TRUE,
  order = NULL,
  name = NULL
)
}
\arguments{
\item{mapping}{Additional default list of aesthetic mappings to use for plot.}

\item{size}{Plot size, can be an \link[grid:unit]{unit} object.}

\item{free_labs}{A boolean value or a string containing one or more of
\code{"t"},\code{"l"},\code{"b"},and \code{"r"} indicates which axis title should be free from
alignment. If \code{NULL}, all axis title will be aligned. Default: "tlbr".}

\item{free_spaces}{A character specifies the ggplot elements which won't
count space sizes when alignment. If \code{NULL} (default), no space will be
removed. See \code{\link[=free_space]{free_space()}} for allowed values.}

\item{plot_data}{A function used to transform the plot data before rendering.
By default, it'll inherit from the parent layout. If no parent layout, the
default is to not modify the data. Use \code{NULL}, if you don't want to modify
anything.

Used to modify the data after layout has been created, but before the data is
handled of to the ggplot2 for rendering. Use this hook if the you needs
change the default data for all \code{geoms}.}

\item{limits}{A boolean value indicates whether to set the layout limtis for
the plot.}

\item{facet}{A boolean value indicates whether to set the layout facet for
the plot. If this is \code{FALSE}, \code{limits} will always be \code{FALSE} too.}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the layout order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A \code{AlignPanel} object.
}
\description{
This is similar with \code{ggalign()} function, but it will always use the layout
panel data. \code{ggpanel} is just an alias of \code{align_panel}.
}
\section{ggplot2 specification}{

\code{align_panel} initializes a \code{ggplot} data and \code{mapping}.

The internal will always use a default mapping of \code{aes(y = .data$.y)} or
\code{aes(x = .data$.x)}.

The data in the underlying \code{ggplot} object contains following columns:
\itemize{
\item \code{.panel}: the panel for current layout axis.
\item \code{.index}: the index of the original layout data.
\item \code{.x} or \code{.y}: the \code{x} or \code{y} coordinates
}
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    ggalign() +
    geom_point(aes(y = value))
}
