% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-eta-pairs.R
\name{eta_pairs}
\alias{eta_pairs}
\title{This creates an eta correlation which defines the relationship between parameters}
\usage{
eta_pairs(
  title,
  dname = NULL,
  type.eta = c("mode", "mean"),
  text_color = "black",
  is.shrink = TRUE,
  is.smooth = TRUE,
  smooth = NULL,
  point = NULL,
  shrink = NULL,
  is.hline = FALSE,
  hline = NULL,
  is.vreference_line = FALSE,
  vreference_line = list(colour = "orange", linetype = "longdash"),
  ...
)
}
\arguments{
\item{title}{character the plot title}

\item{dname}{name of dataset to be used}

\item{type.eta}{\code{character} type of eat can be 'mode' or 'mean'.'mode' by default}

\item{text_color}{color of the correlation text in the upper matrix}

\item{is.shrink}{\code{logical} if TRUE add shrinkage to the plot}

\item{is.smooth}{\code{logical} if TRUE add smoothing to lower matrix plots}

\item{smooth}{\code{list} geom_smooth graphical parameters}

\item{point}{\code{list} geom_point graphical parameter}

\item{shrink}{\code{list} shrinkage graphical parameter}

\item{is.hline}{\code{logical} if TRUE add horizontal line to lower matrix plots}

\item{hline}{\code{list} geom_hline graphical parameters}

\item{is.vreference_line}{\code{logical} if TRUE add the +- 1.96 lines}

\item{vreference_line}{\code{list} geom_hline graphical parameters for the reference lines}

\item{...}{others graphics arguments passed to \code{\link{pmx_gpar}} internal object.}
}
\value{
ecorrel object
}
\description{
This creates an eta correlation which defines the relationship between parameters
}
\seealso{
Other plot_pmx: 
\code{\link{distrib}()},
\code{\link{eta_cov}()},
\code{\link{individual}()},
\code{\link{plot_pmx.distrib}()},
\code{\link{plot_pmx.eta_cov}()},
\code{\link{plot_pmx.eta_pairs}()},
\code{\link{plot_pmx.individual}()},
\code{\link{plot_pmx.pmx_dens}()},
\code{\link{plot_pmx.pmx_gpar}()},
\code{\link{plot_pmx.pmx_qq}()},
\code{\link{plot_pmx.residual}()},
\code{\link{plot_pmx}()}
}
\concept{plot_pmx}
