% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eth.R
\name{eth_call}
\alias{eth_call}
\title{New message call.}
\usage{
eth_call(from = -1, to, gas = 30000, gas_price = -1, value = -1,
  data = -1, number = "latest")
}
\arguments{
\item{from}{Address - Address the call is send from.}

\item{to}{Address - Address the call is send to.}

\item{gas}{Integer - Gas provided for the call execution. \code{eth_call}
consumes zero gas, but this parameter may be needed by some executions.}

\item{gas_price}{Integer - Value of the gas for this call.}

\item{value}{Integer - Value sent with the call}

\item{data}{Data - Hash of the method signature and encoded parameters. For
details see Ethereum Contract ABI
\url{https://solidity.readthedocs.io/en/develop/abi-spec.html}.}

\item{number}{Integer|Tag - Integer block number, or the string 'latest',
'earliest' or 'pending', see the default block parameter
\url{https://github.com/ethereum/wiki/wiki/JSON-RPC#the-default-block-parameter}}
}
\value{
Data - Return value of executed call.
}
\description{
\code{eth_call} executes a new message call immediately without creating a
transaction on the block chain.
}
\examples{
\donttest{
eth_call(to = '0xcaf9a0356ddfa779fdbb55c45b22d35673550f30', data = '0x8f8a0d1900
00000000000000000000000000000000000000000000000000000000000006000000000000000000
0000000000000000000000000000000000000000000002')
}

}
\seealso{
Other eth functions: \code{\link{eth_accounts}},
  \code{\link{eth_blockNumber}},
  \code{\link{eth_coinbase}},
  \code{\link{eth_estimateGas}},
  \code{\link{eth_gasPrice}}, \code{\link{eth_getBalance}},
  \code{\link{eth_getBlockByHash}},
  \code{\link{eth_getBlockByNumber}},
  \code{\link{eth_getBlockTransactionCountByHash}},
  \code{\link{eth_getBlockTransactionCountByNumber}},
  \code{\link{eth_getCode}},
  \code{\link{eth_getFilterChanges}},
  \code{\link{eth_getFilterLogs}},
  \code{\link{eth_getLogs}}, \code{\link{eth_getProof}},
  \code{\link{eth_getStorageAt}},
  \code{\link{eth_getTransactionByBlockHashAndIndex}},
  \code{\link{eth_getTransactionByBlockNumberAndIndex}},
  \code{\link{eth_getTransactionByHash}},
  \code{\link{eth_getTransactionCount}},
  \code{\link{eth_getTransactionReceipt}},
  \code{\link{eth_getUncleByBlockHashAndIndex}},
  \code{\link{eth_getUncleByBlockNumberAndIndex}},
  \code{\link{eth_getUncleCountByBlockHash}},
  \code{\link{eth_getUncleCountByBlockNumber}},
  \code{\link{eth_getWork}}, \code{\link{eth_hashrate}},
  \code{\link{eth_mining}},
  \code{\link{eth_newBlockFilter}},
  \code{\link{eth_newFilter}},
  \code{\link{eth_newPendingTransactionFilter}},
  \code{\link{eth_protocolVersion}},
  \code{\link{eth_sendRawTransaction}},
  \code{\link{eth_sendTransaction}},
  \code{\link{eth_sign}}, \code{\link{eth_submitHashrate}},
  \code{\link{eth_submitWork}}, \code{\link{eth_syncing}},
  \code{\link{eth_uninstallFilter}}, \code{\link{gethr}},
  \code{\link{personal_sendTransaction}}
}
\concept{eth functions}
