\name{gesso.fit}
\alias{gesso.fit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
gesso fit
}
\description{
Fits hierNet GxE model over the two dimentional grid of hyperparmeters \code{lambda_1} and \code{lambda_2}, returns estimated coefficients for each pair of hyperparameters.
}
\usage{
gesso.fit(G, E, Y, C = NULL, normalize = TRUE, normalize_response = FALSE, grid = NULL,
          grid_size = 20, grid_min_ratio = 1e-2, alpha = NULL, family = "gaussian", 
          weights = NULL, tolerance = 1e-3, max_iterations = 10000, 
          min_working_set_size = 100, verbose = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{G}{matrix of main effects of size \code{n x p}, variables organized by columns}
  \item{E}{vector of environmental measurments}
  \item{Y}{outcome vector. Set \code{family="gaussian"} for the continuous outcome and 
          \code{family="binomial"} for the binary outcome with 0/1 levels}
  \item{C}{matrix of confounders of size \code{n x m}, variables organized by columns}    
  \item{normalize}{\code{TRUE} to normalize matrix \code{G} and vector \code{E}}
  \item{normalize_response}{\code{TRUE} to normalize vector \code{Y}}
  \item{grid}{grid sequence for tuning hyperparameters, we use the same grid for \code{lambda_1} and \code{lambda_2}}
  \item{grid_size}{specify \code{grid_size} to generate grid automatically. Grid is generated by calculating \code{max_lambda} from the data (smallest lambda such that all the coefficients are zero). \code{min_lambda} is calculated as a product of \code{max_lambda} and \code{grid_min_ratio}. The program then generates \code{grid_size} values equidistant on the log10 scale from \code{min_lambda} to \code{max_lambda}}
  \item{grid_min_ratio}{parameter to determine \code{min_lambda} (smallest value for the grid of lambdas)}
  \item{alpha}{if \code{NULL} independent 2D grid is used for (\code{lambda_1}, \code{lambda_2}), else 1D grid is used where \code{lambda_2} = \code{alpha} * \code{lambda_1}, i.e. (\code{lambda_1}, \code{alpha} * \code{lambda_1})}
  \item{family}{\code{"gaussian"} for continuous outcome and \code{"binomial"} for binary}
  \item{tolerance}{tolerance for the dual gap convergence criterion}
  \item{max_iterations}{maximum number of iterations}
  \item{min_working_set_size}{minimum size of the working set}
  \item{weights}{inner fitting parameter}
  \item{verbose}{\code{TRUE} to print messages}
}
\value{
A list of estimated coefficients and other model fit metrics for each pair of hyperparameters (\code{lambda_1}, \code{lambda_2})
\item{beta_0}{vector of estimated intercept values of size \code{lambda_1}*\code{lambda_2}}
\item{beta_e}{vector of estimated environment coefficients of size \code{lambda_1}*\code{lambda_2}}
\item{beta_g}{matrix of estimated main effects coefficients organized by rows, size (\code{lambda_1}*\code{lambda_2}) by \code{p}}
\item{beta_gxe}{matrix of estimated interactions coefficients organized by rows, size (\code{lambda_1}*\code{lambda_2}) by \code{p}}
\item{beta_c}{matrix of estimated confounders coefficients organized by rows, size (\code{lambda_1}*\code{lambda_2}) by \code{m}, where \code{m} is the number of confounders}
\item{num_iterations}{number of iterations until convergence for each fit}
\item{working_set_size}{maximum number of variables in the working set for each fit}
\item{has_converged}{1 if the model converged within given \code{max_iterations}, 0 otherwise}
\item{objective_value}{objective function (loss) value for each fit}
\item{beta_g_nonzero}{number of estimated non-zero main effects for each fit}
\item{beta_gxe_nonzero}{number of estimated non-zero interactions for each fit}
\item{lambda_1}{\code{lambda_1} path values, decreasing}
\item{lambda_2}{\code{lambda_2} path values, oscillating}
\item{grid}{vector of values used for hyperparameters tuning}
%\item{num_fitered_by_safe_g}{}
%\item{num_fitered_by_safe_gxe}{}
}
\examples{
data = data.gen()
fit = gesso.fit(G=data$G_train, E=data$E_train, Y=data$Y_train, normalize=TRUE)
plot(fit$beta_g_nonzero, pch=19, cex=0.4, 
     ylab="num of non-zero features", xlab="lambdas path")
points(fit$beta_gxe_nonzero, pch=19, cex=0.4, col="red")
}
