% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calCost.R
\name{contourBetween}
\alias{contourBetween}
\title{contourBetween}
\usage{
contourBetween(map, krigGrid, q1, q2, nbContourBetween = 5)
}
\arguments{
\item{map}{: object map defined in package geozoning}

\item{krigGrid}{: object that can}

\item{q1, q2}{: 2 quantiles that defined zone}

\item{nbContourBetween}{: the number of discretisation between q1 and q2}
}
\value{
listContours : List of Spatial Lines and the value of quantile that represent the contours generated
}
\description{
contourBetween
}
\details{
: For the given krigGrid, this funtion returns the contourLines of the map following
           the 2 quantiles that defined at the beginning.
}
\examples{
\donttest{
 map=geozoning::mapTest
 ZK=initialZoning(qProb=c(0.55,0.85),map)
 Z=ZK$resZ$zonePolygone # list of zones
 lab = ZK$resZ$lab # label of zones
 plotM(map = map,Z = Z,lab = lab, byLab = FALSE)
 numZ = 7
 Estimation = Transition_Zone_Near_Boundary(map = map, Z = Z, numZ = numZ)
 result = new_krigGrid_for_visualisation(map = map, Z = Z, numZ = numZ, solution = Estimation)
 new_krigGrid = result$new_krigGrid
 new_data = result$new_data
 quant1 = quantile(map$krigData@data$var1.pred,probs = 0.55)
 quant2 = quantile(map$krigData@data$var1.pred,probs = 0.85)
 # plot modified isocontours
 plotM(map = map,Z = Z,lab = lab, byLab = TRUE)
 listContours = contourBetween(map = map, krigGrid = new_krigGrid, q1 = quant1, q2 = quant2)
 for (i in 1:length(listContours)){
    sp::plot(listContours[[i]]$contour,add=TRUE,col = "red")
 }
}
}
