% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-vegetation-indices.R
\name{analyze_crop_vegetation}
\alias{analyze_crop_vegetation}
\title{Specialized crop vegetation analysis}
\usage{
analyze_crop_vegetation(
  spectral_data,
  crop_type = "general",
  growth_stage = "unknown",
  analysis_type = "comprehensive",
  cdl_mask = NULL,
  reference_data = NULL,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{spectral_data}{Multi-band spectral data (file, directory, or SpatRaster)}

\item{crop_type}{Crop type for specialized analysis ("corn", "soybeans", "wheat", "general")}

\item{growth_stage}{Growth stage if known ("early", "mid", "late", "harvest")}

\item{analysis_type}{Type of analysis: "comprehensive", "stress", "growth", "yield"}

\item{cdl_mask}{Optional CDL mask for crop-specific analysis}

\item{reference_data}{Optional reference data for validation}

\item{output_folder}{Optional output folder for results}

\item{verbose}{Print detailed progress}
}
\value{
List with comprehensive vegetation analysis results:
\itemize{
\item \code{vegetation_indices}: SpatRaster with calculated indices
\item \code{analysis_results}: Detailed analysis results by type
\item \code{metadata}: Analysis metadata and parameters
}
}
\description{
Perform comprehensive vegetation analysis specifically designed for crop monitoring
including growth stage detection, stress identification, and yield prediction support.
Handles test scenarios properly with better input validation.
}
\details{
\subsection{Crop-Specific Index Selection:}{
\itemize{
\item \strong{Corn}: NDVI, EVI, GNDVI, DVI, RVI, PRI
\item \strong{Soybeans}: NDVI, EVI, SAVI, GNDVI, PRI
\item \strong{Wheat}: NDVI, EVI, SAVI, DVI
\item \strong{General}: NDVI, EVI, SAVI, GNDVI, DVI, RVI
}
}

\subsection{Analysis Types:}{
\itemize{
\item \strong{comprehensive}: All analyses (stress, growth, yield)
\item \strong{stress}: Focus on stress detection indices
\item \strong{growth}: Growth stage analysis
\item \strong{yield}: Yield prediction support
}
}
}
\examples{
\dontrun{
# These examples require actual spectral data
# Comprehensive corn analysis
corn_analysis <- analyze_crop_vegetation(
  spectral_data = sentinel_data,
  crop_type = "corn",
  analysis_type = "comprehensive",
  cdl_mask = corn_mask
)

# Access results
corn_analysis$vegetation_indices        # SpatRaster with indices
corn_analysis$analysis_results$stress_analysis  # Stress detection results
corn_analysis$metadata$indices_used     # Which indices were calculated

# Stress detection in soybeans
stress_analysis <- analyze_crop_vegetation(
  spectral_data = landsat_stack,
  crop_type = "soybeans",
  analysis_type = "stress",
  growth_stage = "mid"
)
}

\donttest{
# Example with mock spectral data
# Create mock multi-band raster (simulating satellite data)
red_band <- terra::rast(nrows = 5, ncols = 5, crs = "EPSG:4326")
nir_band <- terra::rast(nrows = 5, ncols = 5, crs = "EPSG:4326")
terra::values(red_band) <- runif(25, 0.1, 0.3)   # Typical red values
terra::values(nir_band) <- runif(25, 0.4, 0.8)   # Typical NIR values
spectral_stack <- c(red_band, nir_band)
names(spectral_stack) <- c("red", "nir")

# Analyze with mock data
result <- analyze_crop_vegetation(spectral_stack, crop_type = "general")
print(names(result))  # Should show analysis components
}

}
