% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_trivial_circle.R
\name{geo_trivial_circle}
\alias{geo_trivial_circle}
\title{Circle encompassing up to three points}
\usage{
geo_trivial_circle(coordinate_matrix, ...)
}
\arguments{
\item{coordinate_matrix}{A matrix of latitude and longitude columns and up to three rows}

\item{...}{`alternative` argument to be used when calling \code{\link{geo_midpoint}}}
}
\value{
Returns a list of three elements named radius, center and making. Radius contains a single value representing the circle radius. Center contains a vector of length 2 representing the circle center latitude and longitude. Making contains a matrix of the latitude and longitude points were used as the coordinate_matrix argument.
}
\description{
Generates a center point and radius that represent the smallest circle that contains up to three input points
}
\examples{

# Load required packages
require(mapview)
require(sp)

# Create sample geo dataset
sample_coord <-
   matrix(
        c(
            sample(327131680:419648450, 3) / 10000000,
            sample(-1147301410:-1241938690, 3) / 10000000
        ),
        ncol = 2
    )

# Generate sed center and radius
gtc <- geo_trivial_circle(sample_coord)

# Create 80 sided polygon based on gtc's center and radius
gtc_poly <- geo_surround_poly(gtc$center, gtc$radius, 80)

# Join all the points into a single matrix
bound_poly <- rbind(sample_coord, gtc$center, gtc_poly)

# Create SpacialPoints object and pass to mapview for visualization
mapview(
    SpatialPoints(
        bound_poly[,c(2, 1)],
        proj4string = CRS("+proj=longlat +datum=WGS84")
    )
)


}
\seealso{
\code{\link{geo_sed}} \code{\link{geo_point_dist}}
}
\author{
Shant Sukljian
}
\keyword{circle}
\keyword{disk}
\keyword{enclosing}
\keyword{geo}
\keyword{latitude}
\keyword{longitude}
\keyword{sed}
\keyword{smallest}
