% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSWorkspaceManager.R
\docType{class}
\name{GSWorkspaceManager}
\alias{GSWorkspaceManager}
\title{Geoserver REST API Workspace Manager}
\format{\code{\link{R6Class}} object.}
\usage{
GSWorkspaceManager
}
\value{
Object of \code{\link{R6Class}} with methods for managing the workspaces
 of a GeoServer instance.
}
\description{
Geoserver REST API Workspace Manager
}
\section{Methods}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate a GSManager with the \code{url} of the
   GeoServer and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger). This argument
   accepts two possible values: \code{INFO}: to print only geosapi logs,
   \code{DEBUG}: to print geosapi and CURL logs
 }
 \item{\code{getWorkspaces()}}{
   Get the list of available workspace. Returns an object of class \code{list}
   containing items of class \code{\link{GSWorkspace}}
 }
 \item{\code{getWorkspaceNames()}}{
   Get the list of available workspace names. Returns an vector of class 
   \code{character}
 }
 \item{\code{getWorkspace(ws)}}{
   Get a \code{\link{GSWorkspace}} object given a workspace name.
 }
 \item{\code{createWorkspace(name, uri)}}{
   Creates a GeoServer workspace given a name, and an optional URI. If the URI
   is not specified, GeoServer will automatically create an associated Namespace 
   with the URI being "http://{workspaceName}. If the URI is specified, the method
   invokes the method \code{createNamespace(ns, uri)} of the \code{\link{GSNamespaceManager}}.
   Returns \code{TRUE} if the workspace has been successfully created, \code{FALSE} otherwise
 }
 \item{\code{updateWorkspace(name, uri)}}{
   Updates a GeoServer workspace given a name, and an optional URI. If the URI
   is not specified, GeoServer will automatically update the associated Namespace 
   with the URI being "http://{workspaceName}. If the URI is specified, the method
   invokes the method \code{updateNamespace(ns, uri)} of the \code{\link{GSNamespaceManager}}.
   Returns \code{TRUE} if the workspace has been successfully updated, \code{FALSE} otherwise
 }
 \item{\code{deleteWorkspace(ws)}}{
   Deletes a GeoServer workspace given a name. Returns \code{TRUE} if the 
   workspace has been successfully deleted, \code{FALSE} otherwise
 }
}
}

\examples{
\dontrun{
   GSWorkspaceManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{workspace}
