% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/destination.R
\name{geo_destination}
\alias{geo_destination}
\title{Calculate a destination}
\usage{
geo_destination(from, distance, bearing, units = "kilometers")
}
\arguments{
\item{from}{(character) from starting point}

\item{distance}{(numeric) distance from the starting point}

\item{bearing}{(numeric) ranging from -180 to 180}

\item{units}{(character) miles, kilometers, degrees, or radians}
}
\value{
(character) destination point
}
\description{
Calculate a destination
}
\examples{
point <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#0f0"
   },
   "geometry": {
      "type": "Point",
      "coordinates": [-75.343, 39.984]
   }
}'
geo_destination(point, 50, 90, 'miles')
geo_destination(point, 200, 90)
}
