% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearing.R
\name{geo_bearing}
\alias{geo_bearing}
\title{Calculate bearing}
\usage{
geo_bearing(point1, point2)
}
\arguments{
\item{point1}{start geojson \link{Point}}

\item{point2}{end geojson \link{Point}}
}
\value{
(number) bearing in decimal degrees
}
\description{
Calculate bearing
}
\examples{
point1 <- '{
  "type": "Feature",
  "properties": {
    "marker-color": "#f00"
   },
   "geometry": {
      "type": "Point",
      "coordinates": [-75.343, 39.984]
   }
}'

point2 <- '{
  "type": "Feature",
  "properties": {
     "marker-color": "#0f0"
   },
   "geometry": {
      "type": "Point",
      "coordinates": [-75.534, 39.123]
    }
}'

geo_bearing(point1, point2)
}
