% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geonetwork.R
\name{geonetwork}
\alias{geonetwork}
\title{Create geographic networks}
\usage{
geonetwork(edges, nodes, directed = TRUE, CRS = sp::CRS("+proj=longlat"))
}
\arguments{
\item{edges}{data.frame. Edges list and attributes. See Details.}

\item{nodes}{data.frame. Nodes list and attributes. See Details.}

\item{directed}{logical. Default is to build a directed graph.}

\item{CRS}{CRS object. Coordinate Reference System, as built by
function \code{\link[rgdal]{CRS}}.}
}
\value{
An object of class \code{geonetwork}, which also inherits
from \code{igraph}.
}
\description{
Create an \code{igraph} object with geospatial attributes for the
nodes.
}
\details{
The first two columns in \code{edges} must be character or factor,
and match the node names in the first column of the \code{nodes}
data.frame. The third column, if any, will be used as edge weights.
The remaining columns will be used as additional edge attributes.

The first column in \code{nodes} must be character or factor and
provide node names or labels, not necessarily unique. Columns 2
and 3 must be numeric coordinates in the Coordinate Reference
System specified in \code{CRS}.
}
\examples{
  e <- data.frame(from = c("A", "A"), to = c("B", "C"))
  n <- data.frame(id = LETTERS[1:3], x = c(0, 0, 1), y = c(0, 1, 0))
  geonetwork(e, n)
}
