% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/define.modules.r
\name{define.modules}
\alias{define.modules}
\title{Define modules (landmark partitions)}
\usage{
define.modules(spec, nmodules)
}
\arguments{
\item{spec}{Name of specimen, as an object matrix containing 2D or 3D landmark coordinates}

\item{nmodules}{Number of modules to be defined}
}
\value{
Function returns a vector of which landmarks belong in which module (e.g. 1,1,1,2,2,3,3,3,2) to be used
with \code{\link{compare.modular.partitions}} option 'landgroups'.
}
\description{
An interactive function to define which landmarks should be assigned to each module (landmark partition).
}
\details{
Function takes a matrix of digitized landmark coordinates (e.g. from \code{\link{mshape}}) and allows the user to assign
landmarks to each module. The output is a list of which
landmarks belong in which partition, to be used by \code{\link{compare.modular.partitions}}.

\subsection{Selection in 2D}{
Choosing which landmarks will be included in each module involves landmark selection using a mouse in
the plot window. The user is prompted to select each landmark in turn to be assigned to module 1: using the LEFT mouse button
(or regular button for Mac users), click on the hollow circle to choose the landmark. Selected landmarks
will be filled in. When all landmarks for module 1 are chosen, press 'esc', and then start selecting
landmarks for module 2. Repeat until all modules are defined.
}

\subsection{Selection in 3D}{
Choosing which landmarks will be included in each module involves landmark selection using a mouse in
the rgl plot window. The user is prompted to select one or more landmarks. To do so, use the RIGHT mouse button
(or command + LEFT button for Mac users), draw a rectangle around landmarks to select.
Selected landmarks will be coloured yellow. Then type into the console a letter (e.g. 1, 2, 3...) to assign selected landmark(s)
to this module. Repeat until all landmarks are assigned to modules.
}
}
\author{
Emma Sherratt
}
\seealso{
\code{\link{compare.modular.partitions}}
}
\keyword{utilities}

