% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getType.R
\name{getType}
\alias{getType}
\alias{getType,ANY-method}
\alias{getType,geom-method}
\alias{getType,Spatial-method}
\alias{getType,sf-method}
\alias{getType,ppp-method}
\alias{getType,Raster-method}
\alias{getType,matrix-method}
\title{Get the type of a spatial object.}
\usage{
\S4method{getType}{ANY}(x)

\S4method{getType}{geom}(x)

\S4method{getType}{Spatial}(x)

\S4method{getType}{sf}(x)

\S4method{getType}{ppp}(x)

\S4method{getType}{Raster}(x)

\S4method{getType}{matrix}(x)
}
\arguments{
\item{x}{the object for which to determine the type.}
}
\value{
A vector of two values giving the general type (vector/raster) and
  the specific type/class of \code{x}.
}
\description{
Get the type of a spatial object.
}
\examples{
getType(x = gtGeoms$polygon)

getType(x = gtSP$SpatialPolygons)

getType(x = gtSF$multiline)

getType(x = gtRasters$categorical)
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayer}()},
\code{\link{getName}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getWindow}()}
}
\concept{getters}
