% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryCoverageDescription.R
\docType{class}
\name{ISOImageryCoverageDescription}
\alias{ISOImageryCoverageDescription}
\title{ISOImageryCoverageDescription}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryCoverageDescription
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery image description
}
\description{
ISOImageryCoverageDescription
}
\section{Fields}{

\describe{
\item{\code{rangeElementdescription}}{[\code{\link{ISOImageryRangeElementDescription}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryCoverageDescription}}
 }
 \item{\code{addRangeElement(description)}}{
   Add range element description, object of class \code{\link{ISOImageryRangeElementDescription}}
 }
 \item{\code{delRangeElementDescription(description)}}{
   Deletes range element description, object of class \code{\link{ISOImageryRangeElementDescription}}
 }
}
}

\examples{
   #create coverage description
   md <- ISOImageryCoverageDescription$new()
   md$setAttributeDescription("test")
   md$setContentType("modelResult")
   
   #adding 3 arbitrary dimensions
   for(i in 1:3){
      band <- ISOBand$new()
      mn <- ISOMemberName$new(aName = sprintf("name \%s",i), attributeType = sprintf("type \%s",i))
      band$setSequenceIdentifier(mn)
      band$setDescriptor("descriptor")
      band$setMaxValue(10)
      band$setMinValue(1)
      gml <- GMLBaseUnit$new(id = sprintf("ID\%s",i))
      gml$setDescriptionReference("someref")
      gml$setIdentifier("identifier", "codespace")
      gml$addName("name1", "codespace")
      gml$addName("name2", "codespace")
      gml$setQuantityTypeReference("someref")
      gml$setCatalogSymbol("symbol")
      gml$setUnitsSystem("somelink")
      band$setUnits(gml)
      band$setPeakResponse(9)
      band$setBitsPerValue(5)
      band$setToneGradation(100)
      band$setScaleFactor(1)
      band$setOffset(4)
      md$addDimension(band)
   }
   
   des <- ISOImageryRangeElementDescription$new()
   des$setName("name")
   des$setDefinition("description")
   des$addRangeElement("record1")
   des$addRangeElement("record2")
   md$addRangeElementDescription(des)
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{description}
\keyword{image}
\keyword{imagery}
