% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionalize.R
\name{regionalize}
\alias{regionalize}
\title{Estimate Regions by Geographic Features}
\usage{
regionalize(shp, lines, adj = adjacency(shp), epsg = 3857)
}
\arguments{
\item{shp}{\code{sf} tibble to estimate regions for}

\item{lines}{\code{sf} tibble which divides \code{shp} into regions}

\item{adj}{adjacency graph}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}
}
\value{
integer vector of regions with \code{nrow(shp)} entries
}
\description{
This offers a basic method for dividing a shape into separate pieces
}
\examples{
data(towns)
# make some weird roadlike feature passing through the towns
lines <- sf::st_sfc(sf::st_linestring(sf::st_coordinates(sf::st_centroid(towns))),
  crs = sf::st_crs(towns)
)
regionalize(towns, lines)
}
