% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{add_edge}
\alias{add_edge}
\title{Add Edges to an Adjacency List}
\usage{
add_edge(adjacency, v1, v2, zero = TRUE)
}
\arguments{
\item{adjacency}{list of adjacent precincts}

\item{v1}{integer or integer array for first vertex to connect. 
If array, connects each to corresponding entry in v2.}

\item{v2}{integer or integer array for second vertex to connect.
If array, connects each to corresponding entry in v1.}

\item{zero}{boolean, TRUE if the list is zero indexed. False if one indexed.}
}
\value{
adjacency list.
}
\description{
Add Edges to an Adjacency List
}
\examples{
data(towns)
adj <- adjacency(towns)
add_edge(adj, 2, 3)

}
\concept{fix}
